<?php
// admin/_auth.php
// Central auth + role helpers for TUMESSE EVENTS

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['admin_id'])) {
    header('Location: admin_login.php');
    exit;
}

$ADMIN_ID       = (int)($_SESSION['admin_id']);
$ADMIN_USERNAME = $_SESSION['admin_username'] ?? '';
$ADMIN_NAME     = $_SESSION['admin_name'] ?? $ADMIN_USERNAME;
$ADMIN_ROLE     = $_SESSION['admin_role'] ?? 'admin';

/**
 * Require that the current user has one of the allowed roles.
 *
 * @param array $roles
 * @return void
 */
function require_role(array $roles): void
{
    global $ADMIN_ROLE;

    if (!in_array($ADMIN_ROLE, $roles, true)) {
        http_response_code(403);
        echo '<!doctype html><html><head><meta charset="utf-8"><title>Access denied</title></head>';
        echo '<body style="font-family:system-ui,-apple-system,BlinkMacSystemFont,sans-serif;padding:24px;background:#f9fafb;color:#111827;">';
        echo '<h2 style="margin-top:0;">Access denied</h2>';
        echo '<p>You do not have permission to access this area.</p>';
        echo '<p><a href="dashboard.php" style="color:#2563eb;text-decoration:none;">&larr; Back to dashboard</a></p>';
        echo '</body></html>';
        exit;
    }
}