<?php
// admin/_layout_top.php
require_once __DIR__ . '/../src/settings.php';
require_once __DIR__ . '/../src/events.php';

// ---- BRANDING / EVENT CONTEXT ------------------------------------------------
$eventNameSetting  = get_setting('event_name', 'TUMESSE EVENTS');
$eventDateSetting  = get_setting('event_date', '');
$eventVenueSetting = get_setting('event_venue', '');
$eventThemeSetting = get_setting('event_theme', '');

// Multi-event: get current event from events table (global switcher)
$currentEventId = getCurrentEventId();
$events         = getAllEvents();
$currentEvent   = null;

foreach ($events as $ev) {
    if ((int)$ev['id'] === $currentEventId) {
        $currentEvent = $ev;
        break;
    }
}

// Display values: prefer DB event, fallback to settings
$eventName  = $currentEvent['name']        ?? $eventNameSetting;
$eventDate  = $currentEvent['event_date']  ?? $eventDateSetting;
$eventVenue = $currentEvent['venue']       ?? $eventVenueSetting;
$eventTheme = $currentEvent['theme']       ?? $eventThemeSetting;

// ---- ADMIN CONTEXT & ROLES ---------------------------------------------------
$adminName  = $_SESSION['admin_name'] ?? ($_SESSION['admin_username'] ?? 'Admin');
$adminRole  = $_SESSION['admin_role'] ?? 'admin';

if (!isset($pageTitle))  $pageTitle  = 'Dashboard';
if (!isset($activeMenu)) $activeMenu = 'dashboard';

// Role capabilities (menu visibility)
$canGuests      = in_array($adminRole, ['owner','super_admin','admin','event_manager'], true);
$canBulkSms     = in_array($adminRole, ['owner','super_admin','admin','event_manager'], true);
$canReports     = in_array($adminRole, ['owner','super_admin','admin','event_manager','finance','viewer'], true);
$canScanner     = in_array($adminRole, ['owner','super_admin','admin','event_manager','gate'], true);
$canTemplates   = in_array($adminRole, ['owner','super_admin','admin','event_manager'], true);
$canSmsTemplates= $canTemplates;
$canSmsLogs     = in_array($adminRole, ['owner','super_admin','admin','event_manager','finance','viewer'], true);
$canRsvps       = in_array($adminRole, ['owner','super_admin','admin','event_manager','viewer'], true);
$canEvents      = in_array($adminRole, ['owner','super_admin','admin','event_manager'], true);
$canTeam        = in_array($adminRole, ['owner','super_admin'], true);
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($eventName) ?> – <?= htmlspecialchars($pageTitle) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: "Poppins", system-ui, -apple-system, BlinkMacSystemFont, sans-serif;
            background: #f3f4f8;
            color: #222;
        }
        .layout {
            display: flex;
            min-height: 100vh;
            transition: transform .2s ease;
        }

        /* Sidebar */
        .sidebar {
            width: 240px;
            background: radial-gradient(circle at top left, #8e2de2, #4a00e0);
            color: #fff;
            padding: 18px 14px;
            display: flex;
            flex-direction: column;
            box-shadow: 8px 0 22px rgba(15,23,42,.18);
            transform: translateX(0);
            transition: transform .22s ease;
            position: relative;
            z-index: 20;
        }
        .layout.sidebar-hidden .sidebar {
            transform: translateX(-110%);
        }

        .sidebar-brand {
            font-size: 1.05rem;
            font-weight: 600;
            letter-spacing: .12em;
            text-transform: uppercase;
            margin-bottom: 3px;
        }
        .sidebar-subtitle { font-size: .8rem; opacity: .85; margin-bottom: 18px; }
        .sidebar-subtitle span { display:block; }

        .nav-section-title {
            font-size: .75rem;
            text-transform: uppercase;
            opacity: .7;
            margin: 8px 0 4px;
        }
        .nav-list { list-style: none; padding: 0; margin: 0 0 16px; }
        .nav-list li { margin-bottom: 4px; }
        .nav-link {
            display: flex;
            align-items:center;
            gap:8px;
            text-decoration: none;
            color: #f5f6ff;
            font-size: .9rem;
            padding: 8px 10px;
            border-radius: 8px;
            transition: background .15s ease, transform .05s ease, box-shadow .15s;
        }
        .nav-link-icon {
            width:18px;
            text-align:center;
            opacity:.9;
            font-size:.9rem;
        }
        .nav-link:hover {
            background: rgba(255,255,255,.13);
            transform: translateX(2px);
            box-shadow:0 4px 10px rgba(15,23,42,.25);
        }
        .nav-link.active {
            background: rgba(255,255,255,.22);
            font-weight: 600;
        }

        .sidebar-footer {
            margin-top: auto;
            font-size: .75rem;
            opacity: .9;
        }
        .sidebar-footer strong { color: #ffe082; }

        /* Main */
        .main { flex: 1; display: flex; flex-direction: column; }

        .topbar {
            background: #fff;
            border-bottom: 1px solid #e2e4ee;
            padding: 10px 18px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 12px;
            position: sticky;
            top:0;
            z-index:10;
        }
        .topbar-left {
            display:flex;
            align-items:flex-start;
            gap:8px;
        }
        .topbar-title {
            font-size: 1.05rem;
            font-weight: 500;
        }
        .topbar-sub {
            font-size: .8rem;
            color: #777;
        }
        .topbar-right {
            font-size: .9rem;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .topbar-logout {
            text-decoration: none;
            font-size: .85rem;
            padding: 6px 10px;
            border-radius: 999px;
            border: 1px solid #e0e2ea;
            color: #444;
            background: #f9fafc;
            transition: background .15s, color .15s, box-shadow .15s;
        }
        .topbar-logout:hover {
            background: #ffebee;
            color: #b71c1c;
            box-shadow:0 4px 10px rgba(248,113,113,.4);
        }

        .sidebar-toggle-btn{
            border:none;
            background:rgba(15,23,42,.03);
            border-radius:999px;
            padding:6px 9px;
            display:flex;
            align-items:center;
            justify-content:center;
            cursor:pointer;
            margin-right:6px;
        }
        .sidebar-toggle-btn span{
            font-size:1rem;
        }

        .event-switcher-label {
            font-size:.75rem;
            color:#6b7280;
        }
        .event-switcher-select {
            padding:4px 8px;
            border-radius:999px;
            border:1px solid #d1d5db;
            font-size:.78rem;
            background:#fff;
            max-width:260px;
        }

        .content {
            padding: 18px 22px 24px;
            flex: 1;
            display: flex;
            flex-direction: column;
            gap: 16px;
        }
        .page-heading {
            margin: 0 0 4px;
            font-size: 1.35rem;
            font-weight: 600;
        }
        .page-subtitle {
            margin: 0 0 16px;
            font-size: .9rem;
            color: #666;
        }

        .grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(190px, 1fr));
            gap: 14px;
        }
        .card {
            background: #fff;
            border-radius: 14px;
            padding: 14px 14px 12px;
            border: 1px solid #e2e4ee;
            box-shadow: 0 8px 18px rgba(15,23,42,.04);
        }
        .card-title {
            font-size: .85rem;
            color:#777;
            margin-bottom: 6px;
            text-transform: uppercase;
            letter-spacing: .06em;
        }
        .card-value {
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 4px;
        }
        .card-meta { font-size: .8rem; color:#999; }

        .card-accent-green { border-top: 3px solid #4caf50; }
        .card-accent-blue  { border-top: 3px solid #2196f3; }
        .card-accent-orange{ border-top: 3px solid #ff9800; }
        .card-accent-purple{ border-top: 3px solid #7e57c2; }

        .actions-row { display: flex; flex-wrap: wrap; gap: 10px; }
        .btn-action {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 9px 14px;
            border-radius: 999px;
            border: 1px solid #d5d8e5;
            font-size: .9rem;
            font-weight: 500;
            text-decoration: none;
            cursor: pointer;
            background: #fff;
            color:#333;
            transition: background .15s, box-shadow .15s, transform .05s;
        }
        .btn-action.primary {
            background: linear-gradient(135deg, #667eea, #764ba2);
            border-color: transparent;
            color:#fff;
            box-shadow: 0 10px 22px rgba(102,126,234,.35);
        }
        .btn-action:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 22px rgba(15,23,42,.12);
            background:#f9fafc;
        }
        .btn-action.primary:hover {
            background: linear-gradient(135deg,#5c6fd4,#6e409f);
        }

        table { width: 100%; border-collapse: collapse; font-size: .86rem; }
        th,td {
            padding: 7px 8px;
            border-bottom: 1px solid #eceff4;
            text-align: left;
        }
        th {
            font-weight: 600;
            color:#666;
            background:#f9f9fc;
        }
        tr:last-child td { border-bottom:none; }

        .badge {
            display:inline-block;
            padding:2px 7px;
            border-radius:999px;
            font-size:.72rem;
            font-weight:500;
        }
        .badge-paid    { background:#e8f5e9;color:#2e7d32; }
        .badge-unpaid  { background:#fff3e0;color:#ef6c00; }
        .badge-used    { background:#e3f2fd;color:#1565c0; }
        .badge-notused { background:#f5f5f5;color:#616161; }

        .footer {
            font-size: .78rem;
            text-align: right;
            padding: 6px 22px 10px;
            color:#999;
            border-top: 1px solid #e2e4ee;
            background:#fafbff;
        }
        .footer strong { color:#555; }

        @media (max-width: 800px) {
            .layout { flex-direction: column; }
            .sidebar {
                position:fixed;
                top:0;
                left:0;
                height:100vh;
            }
            .topbar {
                padding:10px 14px;
            }
            .topbar {
                flex-direction:column;
                align-items:flex-start;
            }
            .topbar-right {
                width:100%;
                justify-content:space-between;
                flex-wrap:wrap;
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            var btn    = document.getElementById('sidebar-toggle-btn');
            var layout = document.querySelector('.layout');
            if (!btn || !layout) return;
            btn.addEventListener('click', function () {
                layout.classList.toggle('sidebar-hidden');
            });
        });
    </script>
</head>
<body>
<div class="layout">

    <!-- Sidebar -->
    <aside class="sidebar">
        <div>
            <div class="sidebar-brand"><?= htmlspecialchars($eventName) ?></div>
            <div class="sidebar-subtitle">
                <span><?= $eventDate ? htmlspecialchars($eventDate) : '' ?></span>
                <span><?= $eventVenue ? htmlspecialchars($eventVenue) : '' ?></span>
            </div>

            <div class="nav-section-title">Main</div>
            <ul class="nav-list">
                <li>
                    <a class="nav-link <?= $activeMenu === 'dashboard' ? 'active' : '' ?>" href="dashboard.php">
                        <span class="nav-link-icon">🏠</span>
                        <span>Dashboard</span>
                    </a>
                </li>

                <?php if ($canGuests): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'add_guest' ? 'active' : '' ?>" href="add_guest.php">
                            <span class="nav-link-icon">➕</span>
                            <span>Add Guest</span>
                        </a>
                    </li>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'guests' ? 'active' : '' ?>" href="guests.php">
                            <span class="nav-link-icon">👥</span>
                            <span>Guests &amp; Tickets</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canBulkSms): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'bulk_sms' ? 'active' : '' ?>" href="send_bulk.php">
                            <span class="nav-link-icon">💬</span>
                            <span>Bulk SMS</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canReports): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'reports' ? 'active' : '' ?>" href="reports.php">
                            <span class="nav-link-icon">📊</span>
                            <span>Reports</span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>

            <div class="nav-section-title">Tools</div>
            <ul class="nav-list">
                <?php if ($canScanner): ?>
                    <li>
                        <a class="nav-link" href="../public/scanner.html" target="_blank">
                            <span class="nav-link-icon">📷</span>
                            <span>Gate Scanner</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canTemplates): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'templates' ? 'active' : '' ?>" href="templates.php">
                            <span class="nav-link-icon">💌</span>
                            <span>Card Templates</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canSmsTemplates): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'sms_templates' ? 'active' : '' ?>" href="sms_templates.php">
                            <span class="nav-link-icon">✉️</span>
                            <span>SMS Templates</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canSmsLogs): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'sms_logs' ? 'active' : '' ?>" href="sms_logs.php">
                            <span class="nav-link-icon">📜</span>
                            <span>SMS Logs</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canRsvps): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'rsvps' ? 'active' : '' ?>" href="rsvps.php">
                            <span class="nav-link-icon">✅</span>
                            <span>RSVPs</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canEvents): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'events' ? 'active' : '' ?>" href="events.php">
                            <span class="nav-link-icon">📅</span>
                            <span>Events</span>
                        </a>
                    </li>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'event_settings' ? 'active' : '' ?>" href="event_settings.php">
                            <span class="nav-link-icon">⚙️</span>
                            <span>Event Settings</span>
                        </a>
                    </li>
                <?php endif; ?>

                <?php if ($canTeam): ?>
                    <li>
                        <a class="nav-link <?= $activeMenu === 'admins' ? 'active' : '' ?>" href="admins.php">
                            <span class="nav-link-icon">👤</span>
                            <span>Team &amp; Access</span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>

        <div class="sidebar-footer">
            Powered by <strong>TekiSOFT</strong><br>
            <span>Smart solutions for modern events</span>
        </div>
    </aside>

    <!-- Main -->
    <div class="main">
        <header class="topbar">
            <div class="topbar-left">
                <button type="button" class="sidebar-toggle-btn" id="sidebar-toggle-btn" title="Show / hide menu">
                    <span>☰</span>
                </button>
                <div>
                    <div class="topbar-title"><?= htmlspecialchars($pageTitle) ?></div>
                    <div class="topbar-sub">
                        <?= htmlspecialchars($eventName) ?>
                        <?= $eventTheme ? ' · Theme: ' . htmlspecialchars($eventTheme) : '' ?>
                    </div>
                </div>
            </div>

            <div class="topbar-right">
                <!-- Global event switcher -->
                <form method="get" id="event-switcher-form"
                      style="display:flex;align-items:center;gap:6px;">
                    <span class="event-switcher-label">Event:</span>
                    <select name="event_id"
                            class="event-switcher-select"
                            onchange="document.getElementById('event-switcher-form').submit()">
                        <?php foreach ($events as $ev): ?>
                            <option value="<?= (int)$ev['id'] ?>"
                                <?= (int)$ev['id'] === $currentEventId ? 'selected' : '' ?>>
                                <?= htmlspecialchars($ev['name']) ?>
                                <?php if (!empty($ev['event_date'])): ?>
                                    (<?= htmlspecialchars($ev['event_date']) ?>)
                                <?php endif; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </form>

                <span>
                    Hello, <?= htmlspecialchars($adminName) ?>
                    <span style="font-size:.75rem;color:#9ca3af;">
                        (<?= htmlspecialchars($adminRole) ?>)
                    </span>
                </span>
                <a class="topbar-logout" href="logout.php">Logout</a>
            </div>
        </header>

        <main class="content">