<?php
session_start();
require_once __DIR__ . '/../src/db.php';

if (!empty($_SESSION['admin_id'])) {
    header('Location: dashboard.php');
    exit;
}

$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = trim($_POST['username'] ?? '');
    $p = $_POST['password'] ?? '';

    if ($u === '' || $p === '') {
        $err = 'Please enter username and password.';
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admins WHERE username = ? AND is_active = 1 LIMIT 1");
        $stmt->execute([$u]);
        $a = $stmt->fetch();

        if ($a && password_verify($p, $a['password_hash'])) {
            $_SESSION['admin_id']       = (int)$a['id'];
            $_SESSION['admin_username'] = $a['username'];
            $_SESSION['admin_name']     = $a['name'] ?: $a['username'];
            $_SESSION['admin_role']     = $a['role'] ?: 'admin';

            // Backwards compatible with old code using $_SESSION['admin']
            $_SESSION['admin'] = $_SESSION['admin_name'];

            header('Location: dashboard.php');
            exit;
        } else {
            $err = 'Invalid username or password.';
        }
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>TUMESSE EVENTS – Admin Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Optional Google Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: "Poppins", system-ui, -apple-system, BlinkMacSystemFont, sans-serif;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: radial-gradient(circle at top left, #ff9a9e, #fad0c4), 
                        linear-gradient(135deg, #667eea, #764ba2);
            background-blend-mode: screen;
        }
        .login-wrapper {
            width: 100%;
            max-width: 420px;
            padding: 20px;
        }
        .login-card {
            background: rgba(255, 255, 255, 0.97);
            border-radius: 18px;
            box-shadow: 0 18px 45px rgba(0, 0, 0, 0.18);
            padding: 32px 28px 24px;
            position: relative;
            overflow: hidden;
        }
        .login-card::before {
            content: "";
            position: absolute;
            width: 140px;
            height: 140px;
            border-radius: 50%;
            background: rgba(102, 126, 234, 0.12);
            top: -40px;
            right: -40px;
        }
        .app-name {
            font-size: 1.2rem;
            font-weight: 600;
            letter-spacing: 0.08em;
            text-transform: uppercase;
            color: #764ba2;
        }
        .title {
            margin: 10px 0 4px;
            font-size: 1.6rem;
            font-weight: 600;
            color: #222;
        }
        .subtitle {
            margin: 0 0 18px;
            font-size: 0.9rem;
            color: #666;
        }
        .error {
            background: #ffe5e5;
            border: 1px solid #ffb3b3;
            color: #b30000;
            padding: 8px 12px;
            border-radius: 8px;
            font-size: 0.85rem;
            margin-bottom: 14px;
        }
        label {
            display: block;
            font-size: 0.9rem;
            margin-bottom: 4px;
            color: #444;
        }
        .input-group {
            margin-bottom: 14px;
        }
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 10px 11px;
            border-radius: 10px;
            border: 1px solid #ddd;
            font-size: 0.95rem;
            outline: none;
            transition: all 0.15s ease;
        }
        input[type="text"]:focus,
        input[type="password"]:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 2px rgba(102, 126, 234, 0.18);
        }
        .btn-submit {
            width: 100%;
            border: none;
            padding: 11px 14px;
            border-radius: 999px;
            font-size: 0.98rem;
            font-weight: 600;
            cursor: pointer;
            background: linear-gradient(135deg, #667eea, #764ba2);
            color: #fff;
            margin-top: 6px;
            transition: transform 0.08s ease, box-shadow 0.08s ease;
            box-shadow: 0 10px 25px rgba(118, 75, 162, 0.35);
        }
        .btn-submit:hover {
            transform: translateY(-1px);
            box-shadow: 0 14px 30px rgba(118, 75, 162, 0.45);
        }
        .btn-submit:active {
            transform: translateY(0);
            box-shadow: 0 8px 18px rgba(118, 75, 162, 0.3);
        }
        .footer {
            margin-top: 18px;
            font-size: 0.8rem;
            text-align: center;
            color: #888;
        }
        .footer strong {
            color: #444;
        }
        .brand-tagline {
            font-size: 0.8rem;
            color: #999;
            margin-top: 4px;
        }
        @media (max-width: 480px) {
            .login-card {
                padding: 26px 20px 18px;
            }
        }
    </style>
</head>
<body>
<div class="login-wrapper">
    <div class="login-card">
        <div class="app-name">TUMESSE EVENTS</div>
        <div class="title">Admin Panel</div>
        <p class="subtitle">Login to manage invitations, guest lists and event access.</p>

        <?php if ($err): ?>
            <div class="error"><?= htmlspecialchars($err) ?></div>
        <?php endif; ?>

        <form method="post" autocomplete="off">
            <div class="input-group">
                <label for="username">Username</label>
                <input id="username" name="username" type="text" placeholder="Enter your username" required>
            </div>

            <div class="input-group">
                <label for="password">Password</label>
                <input id="password" name="password" type="password" placeholder="Enter your password" required>
            </div>

            <button class="btn-submit" type="submit">Sign in</button>
        </form>

        <div class="footer">
            Powered by <strong>TekiSOFT</strong>
            <div class="brand-tagline">Smart solutions for modern events</div>
        </div>
    </div>
</div>
</body>
</html>