<?php
// admin/delete_guest.php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$currentEventId = getCurrentEventId();
$id = (int)($_GET['id'] ?? 0);

if ($id <= 0) {
    header('Location: guests.php?msg=' . urlencode('Invalid guest ID.'));
    exit;
}

// Ensure we only delete within current event (extra safety)
$stmt = $pdo->prepare("SELECT id, name FROM users WHERE id = ? AND event_id = ? LIMIT 1");
$stmt->execute([$id, $currentEventId]);
$guest = $stmt->fetch();

if (!$guest) {
    header('Location: guests.php?msg=' . urlencode('Guest not found for this event.'));
    exit;
}

// Delete guest
$pdo->prepare("DELETE FROM users WHERE id = ? AND event_id = ?")
    ->execute([$id, $currentEventId]);

header('Location: guests.php?msg=' . urlencode('Guest "' . $guest['name'] . '" has been deleted.'));
exit;