<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/tickets.php';
require_once __DIR__ . '/../src/events.php';

$pageTitle  = 'Edit Guest';
$activeMenu = 'guests';

$id = (int)($_GET['id'] ?? 0);
$guest = getGuestById($id);

if (!$guest) {
    echo "Guest not found.";
    exit;
}

$event = getEventById((int)$guest['event_id']);

$msg = '';
$templates = ['card_minimal','card_photo','card_elegant','card_modern','card_dark','card_mahemba'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name     = trim($_POST['name'] ?? '');
    $phone    = trim($_POST['phone'] ?? '');
    $email    = trim($_POST['email'] ?? '');
    $pricing  = $_POST['pricing'] ?? 'single';
    $template = $_POST['template'] ?? 'card_minimal';

    if ($pricing === 'single')      $peopleCount = 1;
    elseif ($pricing === 'double')  $peopleCount = 2;
    elseif ($pricing === 'triple')  $peopleCount = 3;
    else {
        $peopleCount = (int)($_POST['people_count_custom'] ?? 1);
        if ($peopleCount < 1) $peopleCount = 1;
        $pricing = 'custom';
    }

    $priceTotal = $_POST['price_total'] !== '' ? (float)$_POST['price_total'] : null;
    $amountPaid = $_POST['amount_paid'] !== '' ? (float)$_POST['amount_paid'] : 0.0;

    $paid = 0;
    if ($priceTotal !== null && $priceTotal > 0 && $amountPaid >= $priceTotal) {
        $paid = 1;
    }

    if ($name && $phone) {
        $stmt = $pdo->prepare("UPDATE users
            SET name=?, phone=?, email=?, pricing=?, people_count=?, template=?, price_total=?, amount_paid=?, paid=?
            WHERE id=?");

        $stmt->execute([
            $name,
            $phone,
            $email,
            $pricing,
            $peopleCount,
            $template,
            $priceTotal,
            $amountPaid,
            $paid,
            $guest['id'],
        ]);

        $msg   = 'Guest updated successfully.';
        $guest = getGuestById($guest['id']);
    } else {
        $msg = 'Name and phone are required.';
    }
}

$isCustom = ($guest['pricing'] === 'custom');

include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">Edit Guest</h1>
    <p class="page-subtitle">
        Update guest, ticket size, and payment details.
        <?php if ($event): ?>
            Event: <strong><?= htmlspecialchars($event['name']) ?></strong>
            <?php if (!empty($event['event_date'])): ?>
                (<?= htmlspecialchars($event['event_date']) ?>)
            <?php endif; ?>
        <?php endif; ?>
    </p>
</div>

<div class="card" style="max-width:720px;">
    <?php if ($msg): ?>
        <div style="
            background:#e0f2fe;
            border:1px solid #bfdbfe;
            color:#1d4ed8;
            padding:8px 10px;
            border-radius:8px;
            font-size:.85rem;
            margin-bottom:12px;">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>

    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div class="grid" style="grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:10px;">
            <div>
                <label style="font-size:.85rem;">Full Name</label><br>
                <input type="text" name="name" required
                       value="<?= htmlspecialchars($guest['name']) ?>"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
            <div>
                <label style="font-size:.85rem;">Phone</label><br>
                <input type="text" name="phone" required
                       value="<?= htmlspecialchars($guest['phone']) ?>"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
            <div>
                <label style="font-size:.85rem;">Email (optional)</label><br>
                <input type="email" name="email"
                       value="<?= htmlspecialchars($guest['email']) ?>"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
        </div>

        <div class="grid" style="grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:10px;">
            <div>
                <label style="font-size:.85rem;">Ticket Size</label><br>
                <select name="pricing" id="pricing-select"
                        style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
                    <option value="single"  <?= $guest['pricing']==='single' ? 'selected':''; ?>>Single (1 person)</option>
                    <option value="double"  <?= $guest['pricing']==='double' ? 'selected':''; ?>>Double (2 people)</option>
                    <option value="triple"  <?= $guest['pricing']==='triple' ? 'selected':''; ?>>Triple (3 people)</option>
                    <option value="custom"  <?= $guest['pricing']==='custom' ? 'selected':''; ?>>Custom number of people</option>
                </select>
            </div>
            <div id="custom-people-wrapper" style="<?= $isCustom ? '' : 'display:none;' ?>">
                <label style="font-size:.85rem;">Custom people count</label><br>
                <input type="number" min="1" name="people_count_custom" id="people-count-custom"
                       value="<?= (int)$guest['people_count'] ?>"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
            <div>
                <label style="font-size:.85rem;">Card Template</label><br>
                <select name="template"
                        style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
                    <?php foreach ($templates as $tpl): ?>
                        <option value="<?= htmlspecialchars($tpl) ?>"
                            <?= $guest['template']===$tpl ? 'selected':''; ?>>
                            <?= htmlspecialchars($tpl) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="grid" style="grid-template-columns:repeat(auto-fit,minmax(220px,1fr));gap:10px;">
            <div>
                <label style="font-size:.85rem;">Ticket price (total)</label><br>
                <input type="number" step="0.01" min="0" name="price_total"
                       value="<?= htmlspecialchars($guest['price_total']) ?>"
                       placeholder="e.g. 50,000"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
            <div>
                <label style="font-size:.85rem;">Amount paid</label><br>
                <input type="number" step="0.01" min="0" name="amount_paid"
                       value="<?= htmlspecialchars($guest['amount_paid']) ?>"
                       placeholder="e.g. 20,000"
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
                <div style="font-size:.75rem;color:#6b7280;margin-top:2px;">
                    System marks <strong>Paid</strong> if amount paid ≥ total price.
                </div>
            </div>
        </div>

        <div style="margin-top:6px;display:flex;gap:10px;">
            <button class="btn-action primary" type="submit">Save Changes</button>
            <a href="guests.php" class="btn-action">Back to Guests</a>
        </div>
    </form>
</div>

<script>
    const pricingSelect = document.getElementById('pricing-select');
    const customWrapper = document.getElementById('custom-people-wrapper');

    function toggleCustomPeople() {
        if (pricingSelect.value === 'custom') {
            customWrapper.style.display = '';
        } else {
            customWrapper.style.display = 'none';
        }
    }

    pricingSelect.addEventListener('change', toggleCustomPeople);
</script>

<?php include __DIR__ . '/_layout_bottom.php'; ?>