<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/settings.php';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fields = [
        'event_name'  => $_POST['event_name']  ?? '',
        'event_date'  => $_POST['event_date']  ?? '',
        'event_venue' => $_POST['event_venue'] ?? '',
        'event_theme' => $_POST['event_theme'] ?? '',
    ];

    $stmt = $pdo->prepare("
        INSERT INTO settings (key_name, value)
        VALUES (:k, :v)
        ON DUPLICATE KEY UPDATE value = VALUES(value)
    ");

    foreach ($fields as $k => $v) {
        $stmt->execute([
            ':k' => $k,
            ':v' => $v
        ]);
    }

    $msg = 'Event settings updated successfully.';
}

$eventName  = get_setting('event_name', 'TUMESSE EVENTS');
$eventDate  = get_setting('event_date', '');
$eventVenue = get_setting('event_venue', '');
$eventTheme = get_setting('event_theme', '');

$pageTitle  = 'Event Settings';
$activeMenu = 'event_settings';
include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">Event Settings</h1>
    <p class="page-subtitle">
        Manage your event details. These values appear on the dashboard and on all E-cards sent to your guests.
    </p>
</div>

<div class="card" style="max-width: 520px;">
    <?php if ($msg): ?>
        <div style="
            background:#e8f5e9;
            border:1px solid #c8e6c9;
            color:#2e7d32;
            padding:8px 10px;
            border-radius:8px;
            font-size:.85rem;
            margin-bottom:12px;">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>

    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div>
            <label style="font-size:.85rem;">Event Name</label><br>
            <input type="text"
                   name="event_name"
                   value="<?= htmlspecialchars($eventName) ?>"
                   required
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
        </div>

        <div>
            <label style="font-size:.85rem;">Event Date</label><br>
            <input type="date"
                   name="event_date"
                   value="<?= htmlspecialchars($eventDate) ?>"
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
        </div>

        <div>
            <label style="font-size:.85rem;">Event Venue</label><br>
            <input type="text"
                   name="event_venue"
                   value="<?= htmlspecialchars($eventVenue) ?>"
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
        </div>

        <div>
            <label style="font-size:.85rem;">Theme / Colors (optional)</label><br>
            <input type="text"
                   name="event_theme"
                   value="<?= htmlspecialchars($eventTheme) ?>"
                   placeholder="e.g. Gold & White"
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
        </div>

        <div style="margin-top:6px;display:flex;gap:10px;">
            <button class="btn-action primary" type="submit">Save Settings</button>
            <a href="dashboard.php" class="btn-action">Back to Dashboard</a>
        </div>
    </form>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>