<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$pageTitle  = "Events Manager";
$activeMenu = "events";

// Handle create event
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['action']) && $_POST['action'] === 'create') {
    $name = trim($_POST['name']);
    $event_date = trim($_POST['event_date']);
    $venue = trim($_POST['venue']);
    $theme = trim($_POST['theme']);

    if ($name !== "") {
        $stmt = $pdo->prepare("INSERT INTO events (name, event_date, venue, theme, created_at) VALUES (?,?,?,?,NOW())");
        $stmt->execute([$name, $event_date, $venue, $theme]);
    }
    header("Location: events.php");
    exit;
}

// Handle delete
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM events WHERE id = ?");
    $stmt->execute([$id]);

    // Reset event session if deleted
    if ($_SESSION['current_event_id'] == $id) {
        $_SESSION['current_event_id'] = null;
    }

    header("Location: events.php");
    exit;
}

$events = getAllEvents();
include __DIR__ . '/_layout_top.php';
?>

<h1 class="page-heading">Events Manager</h1>
<p class="page-subtitle">Create, manage and switch between multiple events.</p>

<div class="card" style="max-width:760px;margin-bottom:20px;">
    <h3 style="margin-top:0;">Create New Event</h3>

    <form method="post" style="display:flex;flex-direction:column;gap:12px;">
        <input type="hidden" name="action" value="create">

        <div>
            <label>Event Name</label><br>
            <input type="text" name="name" required
                   style="width:100%;padding:8px;border-radius:6px;border:1px solid #ccc;">
        </div>

        <div>
            <label>Date</label><br>
            <input type="date" name="event_date"
                   style="padding:7px;border-radius:6px;border:1px solid #ccc;width:100%;">
        </div>

        <div>
            <label>Venue</label><br>
            <input type="text" name="venue"
                   style="width:100%;padding:8px;border-radius:6px;border:1px solid #ccc;">
        </div>

        <div>
            <label>Theme</label><br>
            <input type="text" name="theme"
                   style="width:100%;padding:8px;border-radius:6px;border:1px solid #ccc;">
        </div>

        <button class="btn-action primary" type="submit">Create Event</button>
    </form>
</div>

<div class="card">
    <h3 style="margin-top:0;">Existing Events</h3>

    <table>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Date</th>
            <th>Venue</th>
            <th>Theme</th>
            <th>Actions</th>
        </tr>

        <?php foreach ($events as $ev): ?>
            <tr>
                <td><?= $ev['id'] ?></td>
                <td><?= htmlspecialchars($ev['name']) ?></td>
                <td><?= htmlspecialchars($ev['event_date']) ?></td>
                <td><?= htmlspecialchars($ev['venue']) ?></td>
                <td><?= htmlspecialchars($ev['theme']) ?></td>
                <td>
                    <a class="btn-action" href="events_edit.php?id=<?= $ev['id'] ?>">Edit</a>
                    <a class="btn-action" href="events.php?delete=<?= $ev['id'] ?>"
                       onclick="return confirm('Delete this event? This cannot be undone!');"
                       style="color:#b91c1c;">Delete</a>
                </td>
            </tr>
        <?php endforeach; ?>
    </table>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>