<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$eventId = getCurrentEventId();

// Find event for filename
$event = getEventById($eventId);
$eventNameSlug = $event ? preg_replace('/[^a-z0-9]+/i','_', strtolower($event['name'])) : 'event';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="guests_' . $eventNameSlug . '.csv"');

$output = fopen('php://output', 'w');

// Header
fputcsv($output, [
    'ID', 'Name', 'Phone', 'Email',
    'TicketType', 'PeopleCount', 'Template',
    'PriceTotal', 'AmountPaid', 'AmountDue',
    'PaidFlag', 'UsedFlag', 'UsedAt', 'CreatedAt'
]);

$stmt = $pdo->prepare("
    SELECT *
    FROM users
    WHERE event_id = ?
    ORDER BY id ASC
");
$stmt->execute([$eventId]);

while ($g = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $priceTotal = $g['price_total'] !== null ? (float)$g['price_total'] : 0;
    $paid       = (float)($g['amount_paid'] ?? 0);
    $due        = max($priceTotal - $paid, 0);

    fputcsv($output, [
        $g['id'],
        $g['name'],
        $g['phone'],
        $g['email'],
        $g['pricing'],
        $g['people_count'],
        $g['template'],
        $priceTotal,
        $paid,
        $due,
        $g['paid'],
        $g['used'],
        $g['used_at'],
        $g['created_at'],
    ]);
}

fclose($output);
exit;