<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$eventId = getCurrentEventId();

$event = getEventById($eventId);
$eventNameSlug = $event ? preg_replace('/[^a-z0-9]+/i','_', strtolower($event['name'])) : 'event';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="payments_' . $eventNameSlug . '.csv"');

$output = fopen('php://output', 'w');

// Header
fputcsv($output, [
    'GuestID', 'Name', 'Phone',
    'TicketType', 'PeopleCount',
    'PriceTotal', 'AmountPaid', 'AmountDue',
    'PaymentStatus', 'CreatedAt'
]);

$stmt = $pdo->prepare("
    SELECT *
    FROM users
    WHERE event_id = ?
    ORDER BY id ASC
");
$stmt->execute([$eventId]);

while ($g = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $priceTotal = $g['price_total'] !== null ? (float)$g['price_total'] : 0;
    $paid       = (float)($g['amount_paid'] ?? 0);
    $due        = max($priceTotal - $paid, 0);

    // Determine status label
    $statusLabel = 'Unpaid';
    if ($priceTotal > 0) {
        if ($paid >= $priceTotal) {
            $statusLabel = 'Paid in full';
        } elseif ($paid > 0) {
            $statusLabel = 'Partial payment';
        } else {
            $statusLabel = 'Unpaid';
        }
    } else {
        if (!empty($g['paid'])) {
            $statusLabel = 'Paid (no amount set)';
        }
    }

    fputcsv($output, [
        $g['id'],
        $g['name'],
        $g['phone'],
        $g['pricing'],
        $g['people_count'],
        $priceTotal,
        $paid,
        $due,
        $statusLabel,
        $g['created_at'],
    ]);
}

fclose($output);
exit;