<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$eventId = getCurrentEventId();

$event = getEventById($eventId);
$eventNameSlug = $event ? preg_replace('/[^a-z0-9]+/i','_', strtolower($event['name'])) : 'event';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="rsvps_' . $eventNameSlug . '.csv"');

$output = fopen('php://output', 'w');

// Header
fputcsv($output, [
    'ID', 'EventID', 'EventName',
    'Name', 'Phone', 'Message', 'CreatedAt'
]);

$stmt = $pdo->prepare("
    SELECT r.*, e.name AS event_name
    FROM rsvps r
    LEFT JOIN events e ON e.id = r.event_id
    WHERE r.event_id = ?
    ORDER BY r.id ASC
");
$stmt->execute([$eventId]);

while ($r = $stmt->fetch(PDO::FETCH_ASSOC)) {
    fputcsv($output, [
        $r['id'],
        $r['event_id'],
        $r['event_name'],
        $r['name'],
        $r['phone'],
        $r['message'],
        $r['created_at'],
    ]);
}

fclose($output);
exit;