<?php
// admin/guest_payment.php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/tickets.php';
require_once __DIR__ . '/../src/events.php';

$id = (int)($_GET['id'] ?? 0);
$guest = $id ? getGuestById($id) : null;

if (!$guest) {
    echo "Guest not found.";
    exit;
}

$event = getEventById((int)$guest['event_id']);

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $priceTotalInput = $_POST['price_total'] ?? '';
    $mode            = $_POST['mode'] ?? 'add'; // add | override
    $amountInput     = $_POST['amount'] ?? '';

    $currentPriceTotal = $guest['price_total'] !== null ? (float)$guest['price_total'] : 0.0;
    $currentPaid       = (float)$guest['amount_paid'];

    $priceTotal = $priceTotalInput !== '' ? (float)$priceTotalInput : null;
    $amount     = $amountInput !== '' ? (float)$amountInput : 0.0;
    if ($amount < 0) $amount = 0;

    $newPaid = $currentPaid;

    if ($amount > 0) {
        if ($mode === 'add') {
            $newPaid = $currentPaid + $amount;
        } else {
            $newPaid = $amount;
        }
    }

    if ($priceTotal === null && $currentPriceTotal > 0) {
        $priceTotal = $currentPriceTotal;
    }

    $paidFlag = 0;
    if ($priceTotal !== null && $priceTotal > 0 && $newPaid >= $priceTotal) {
        $paidFlag = 1;
    }

    $stmt = $pdo->prepare("UPDATE users
        SET price_total = ?, amount_paid = ?, paid = ?
        WHERE id = ?");

    $stmt->execute([
        $priceTotal,
        $newPaid,
        $paidFlag,
        $guest['id'],
    ]);

    $msg   = 'Payment information updated successfully.';
    $guest = getGuestById($guest['id']);
}

// Recalculate display values
$people      = (int)($guest['people_count'] ?? 1);
$pricing     = $guest['pricing'] ?? 'single';
$priceTotal  = $guest['price_total'] !== null ? (float)$guest['price_total'] : 0.0;
$amountPaid  = (float)($guest['amount_paid'] ?? 0);
$paidFlag    = (int)($guest['paid'] ?? 0);

$due = 0.0;
$paymentLabel = 'Unpaid';
$paymentClass = 'badge-unpaid';

if ($priceTotal > 0) {
    if ($amountPaid >= $priceTotal) {
        $due = 0.0;
        $paymentLabel = 'Paid in full';
        $paymentClass = 'badge-paid';
    } elseif ($amountPaid > 0) {
        $due = max($priceTotal - $amountPaid, 0);
        $paymentLabel = 'Partial payment';
        $paymentClass = 'badge-partial';
    } else {
        $due = $priceTotal;
        $paymentLabel = 'Unpaid';
        $paymentClass = 'badge-unpaid';
    }
} else {
    if ($paidFlag) {
        $paymentLabel = 'Paid (no amount set)';
        $paymentClass = 'badge-paid';
    }
}

$pageTitle  = 'Guest Payment';
$activeMenu = 'guests';

include __DIR__ . '/_layout_top.php';
?>

<style>
    .payment-summary {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 10px;
        margin-bottom: 14px;
    }
    .payment-card {
        background: linear-gradient(135deg, #0f172a, #020617);
        border-radius: 14px;
        color: #e5e7eb;
        padding: 10px 12px;
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 14px 30px rgba(15, 23, 42, 0.35);
        font-size: 0.8rem;
    }
    .payment-label {
        font-size: 0.70rem;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #9ca3af;
        margin-bottom: 2px;
    }
    .payment-value {
        font-size: 1.1rem;
        font-weight: 600;
    }
    .payment-sub {
        font-size: 0.75rem;
        color: #9ca3af;
        margin-top: 2px;
    }
</style>

<div>
    <h1 class="page-heading">Payment – <?= htmlspecialchars($guest['name']) ?></h1>
    <p class="page-subtitle">
        Manage ticket amount and payments for this guest.
        <?php if ($event): ?>
            Event: <strong><?= htmlspecialchars($event['name']) ?></strong>
            <?php if (!empty($event['event_date'])): ?>
                (<?= htmlspecialchars($event['event_date']) ?>)
            <?php endif; ?>
        <?php endif; ?>
    </p>
</div>

<div class="payment-summary">
    <div class="payment-card">
        <div class="payment-label">Guest</div>
        <div class="payment-value"><?= htmlspecialchars($guest['name']) ?></div>
        <div class="payment-sub">
            Ticket: <?= htmlspecialchars(ucfirst($pricing)) ?> ·
            <?= (int)$people ?> <?= $people === 1 ? 'person' : 'people' ?><br>
            Phone: <?= htmlspecialchars($guest['phone']) ?>
        </div>
    </div>
    <div class="payment-card">
        <div class="payment-label">Amount (TZS)</div>
        <div class="payment-value"><?= number_format($priceTotal, 0) ?></div>
        <div class="payment-sub">Current total ticket amount</div>
    </div>
    <div class="payment-card">
        <div class="payment-label">Paid / Due (TZS)</div>
        <div class="payment-value">
            <?= number_format($amountPaid, 0) ?> / <?= number_format($due, 0) ?>
        </div>
        <div class="payment-sub">
            Status:
            <span class="badge <?= $paymentClass ?>"><?= htmlspecialchars($paymentLabel) ?></span>
        </div>
    </div>
</div>

<div class="card" style="max-width:520px;">
    <?php if ($msg): ?>
        <div style="
            background:#e0f2fe;
            border:1px solid #bfdbfe;
            color:#1d4ed8;
            padding:8px 10px;
            border-radius:8px;
            font-size:.85rem;
            margin-bottom:12px;">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>

    <?php if ($err): ?>
        <div style="
            background:#fee2e2;
            border:1px solid #fecaca;
            color:#b91c1c;
            padding:8px 10px;
            border-radius:8px;
            font-size:.85rem;
            margin-bottom:12px;">
            <?= htmlspecialchars($err) ?>
        </div>
    <?php endif; ?>

    <form method="post" style="display:flex;flex-direction:column;gap:10px;">
        <div>
            <label style="font-size:.85rem;">Total ticket amount (TZS)</label><br>
            <input type="number" step="0.01" min="0" name="price_total"
                   value="<?= $priceTotal > 0 ? htmlspecialchars($priceTotal) : '' ?>"
                   placeholder="e.g. 50,000"
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            <div style="font-size:.75rem;color:#6b7280;margin-top:2px;">
                Leave empty to keep current total (<?= number_format($priceTotal,0) ?>).
            </div>
        </div>

        <div>
            <label style="font-size:.85rem;">Payment amount (TZS)</label><br>
            <input type="number" step="0.01" min="0" name="amount"
                   placeholder="e.g. 20,000"
                   style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            <div style="font-size:.75rem;color:#6b7280;margin-top:2px;">
                This is the amount you are recording now.
            </div>
        </div>

        <div>
            <label style="font-size:.85rem;display:block;margin-bottom:4px;">Payment mode</label>
            <label style="font-size:.82rem;margin-right:10px;">
                <input type="radio" name="mode" value="add" checked>
                Add on top of existing paid amount (current: <?= number_format($amountPaid,0) ?>)
            </label><br>
            <label style="font-size:.82rem;">
                <input type="radio" name="mode" value="override">
                Override total paid amount (set new total paid)
            </label>
        </div>

        <div style="margin-top:6px;display:flex;gap:10px;">
            <button class="btn-action primary" type="submit">Save Payment</button>
            <a href="guests.php" class="btn-action">Back to Guests</a>
        </div>
    </form>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>