<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$pageTitle  = 'Guests & Tickets';
$activeMenu = 'guests';

$currentEventId = getCurrentEventId();

// optional message from redirects (delete, etc.)
$flashMsg = $_GET['msg'] ?? '';

// Load guests for current event
$stmt = $pdo->prepare("SELECT * FROM users WHERE event_id = ? ORDER BY created_at DESC LIMIT 500");
$stmt->execute([$currentEventId]);
$rows = $stmt->fetchAll();

$base = rtrim($_ENV['BASE_URL'] ?? '', '/');

// --------- SUMMARY METRICS FOR THIS EVENT ----------
$totalGuests   = 0;
$totalPeople   = 0;
$totalAmount   = 0.0;
$totalPaid     = 0.0;
$totalDue      = 0.0;
$countPaid     = 0;
$countPartial  = 0;
$countUnpaid   = 0;

foreach ($rows as $g) {
    $totalGuests++;

    $people     = (int)($g['people_count'] ?? 1);
    $priceTotal = $g['price_total'] !== null ? (float)$g['price_total'] : null;
    $amountPaid = (float)($g['amount_paid'] ?? 0);
    $paidFlag   = (int)($g['paid'] ?? 0);

    $totalPeople += $people;

    if ($priceTotal !== null && $priceTotal > 0) {
        $totalAmount += $priceTotal;
        $totalPaid   += min($amountPaid, $priceTotal);
        $dueForGuest = max($priceTotal - $amountPaid, 0);
        $totalDue   += $dueForGuest;

        if ($amountPaid >= $priceTotal) {
            $countPaid++;
        } elseif ($amountPaid > 0) {
            $countPartial++;
        } else {
            $countUnpaid++;
        }
    } else {
        if ($paidFlag) {
            $countPaid++;
        } else {
            $countUnpaid++;
        }
    }
}

include __DIR__ . '/_layout_top.php';
?>

<style>
    .summary-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(170px, 1fr));
        gap: 10px;
        margin-bottom: 14px;
    }
    .summary-card {
        background: linear-gradient(135deg, #0f172a, #020617);
        border-radius: 14px;
        color: #e5e7eb;
        padding: 10px 12px;
        border: 1px solid rgba(148,163,184,0.35);
        box-shadow: 0 14px 30px rgba(15, 23, 42, 0.35);
        font-size: 0.8rem;
    }
    .summary-label {
        font-size: 0.70rem;
        text-transform: uppercase;
        letter-spacing: 0.08em;
        color: #9ca3af;
        margin-bottom: 2px;
    }
    .summary-value {
        font-size: 1.1rem;
        font-weight: 600;
    }
    .summary-sub {
        font-size: 0.75rem;
        color: #9ca3af;
        margin-top: 2px;
    }

    .table-guests {
        width: 100%;
        border-collapse: collapse;
        font-size: 0.86rem;
        background: #ffffff;
        border-radius: 14px;
        overflow: hidden;
        box-shadow: 0 18px 35px rgba(15, 23, 42, 0.05);
    }
    .table-guests th,
    .table-guests td {
        padding: 8px 10px;
        border-bottom: 1px solid #e5e7eb;
        vertical-align: top;
        text-align: left;
        white-space: nowrap;
    }
    .table-guests th {
        background: #f3f4f6;
        font-weight: 600;
        font-size: 0.8rem;
        text-transform: uppercase;
        letter-spacing: 0.05em;
        color: #6b7280;
    }
    .table-guests tbody tr:last-child td {
        border-bottom: none;
    }
    .badge {
        display: inline-block;
        padding: 2px 8px;
        border-radius: 999px;
        font-size: 0.72rem;
        line-height: 1.3;
        margin-bottom: 2px;
    }
    .badge-paid { background:#14532d; color:#bbf7d0; }
    .badge-unpaid { background:#7f1d1d; color:#fecaca; }
    .badge-partial { background:#1e293b; color:#facc15; }
    .badge-used { background:#0f172a; color:#a5b4fc; }
    .badge-notused { background:#f97316; color:#fff7ed; }
    .badge-single { background:#0f172a;color:#e5e7eb;border:1px solid #4b5563; }
    .badge-double { background:#0b1120;color:#bfdbfe;border:1px solid #3b82f6; }
    .badge-triple { background:#082f49;color:#f9fafb;border:1px solid #38bdf8; }
    .badge-custom { background:#111827;color:#e5e7eb;border:1px dashed #9ca3af; }

    .table-guests a {
        color: #2563eb;
        text-decoration: none;
    }
    .table-guests a:hover {
        text-decoration: underline;
    }
    .pill-label {
        font-size: 0.75rem;
        color: #6b7280;
    }
    .link-delete {
        color:#b91c1c;
    }
    .link-delete:hover {
        color:#7f1d1d;
    }
</style>

<div>
    <h1 class="page-heading">Guests & Tickets</h1>
    <p class="page-subtitle">
        Manage invitations, ticket sizes, payments (including partial), and gate check-ins for the selected event.
    </p>
</div>

<?php if ($flashMsg): ?>
    <div style="
        background:#ecfdf3;
        border:1px solid #bbf7d0;
        color:#166534;
        padding:8px 10px;
        border-radius:8px;
        font-size:.85rem;
        margin-bottom:12px;">
        <?= htmlspecialchars($flashMsg) ?>
    </div>
<?php endif; ?>

<div class="summary-grid">
    <div class="summary-card">
        <div class="summary-label">Guests</div>
        <div class="summary-value"><?= (int)$totalGuests ?></div>
        <div class="summary-sub"><?= (int)$totalPeople ?> total people (capacity)</div>
    </div>
    <div class="summary-card">
        <div class="summary-label">Amount (TZS)</div>
        <div class="summary-value"><?= number_format($totalAmount, 0) ?></div>
        <div class="summary-sub">Expected total amount</div>
    </div>
    <div class="summary-card">
        <div class="summary-label">Paid / Due (TZS)</div>
        <div class="summary-value">
            <?= number_format($totalPaid, 0) ?> / <?= number_format($totalDue, 0) ?>
        </div>
        <div class="summary-sub">Received / Outstanding</div>
    </div>
    <div class="summary-card">
        <div class="summary-label">Payment status</div>
        <div class="summary-sub">
            <strong><?= (int)$countPaid ?></strong> Paid ·
            <strong><?= (int)$countPartial ?></strong> Partial ·
            <strong><?= (int)$countUnpaid ?></strong> Unpaid
        </div>
    </div>
</div>

<div style="margin-bottom:12px;display:flex;flex-wrap:wrap;gap:8px;">
    <a href="add_guest.php" class="btn-action primary">+ Add Guest</a>
    <a href="../public/scanner.html" class="btn-action" target="_blank">Open Gate Scanner</a>
    <a href="guests_print.php" class="btn-action" target="_blank">Print Guest List</a>
    <a href="send_bulk.php" class="btn-action">Bulk SMS</a>
</div>

<div class="card" style="padding:0;overflow-x:auto;">
    <table class="table-guests">
        <thead>
        <tr>
            <th>ID</th>
            <th>Guest</th>
            <th>Contact</th>
            <th>Ticket</th>
            <th>Template</th>
            <th>Payment</th>
            <th>Check-in</th>
            <th>Links</th>
            <th>Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php if (!$rows): ?>
            <tr>
                <td colspan="9" style="text-align:center;padding:20px;color:#9ca3af;">
                    No guests have been added for this event yet.
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($rows as $g):
                $people      = (int)($g['people_count'] ?? 1);
                $pricing     = $g['pricing'] ?? 'single';
                $template    = $g['template'] ?? 'card_minimal';
                $priceTotal  = $g['price_total'] !== null ? (float)$g['price_total'] : null;
                $amountPaid  = (float)($g['amount_paid'] ?? 0);
                $paidFlag    = (int)($g['paid'] ?? 0);

                // ----- Payment status -----
                $paymentLabel = 'Unpaid';
                $paymentClass = 'badge-unpaid';
                $due          = 0.0;

                if ($priceTotal !== null && $priceTotal > 0) {
                    if ($amountPaid >= $priceTotal) {
                        $paymentLabel = 'Paid in full';
                        $paymentClass = 'badge-paid';
                        $due = 0.0;
                    } elseif ($amountPaid > 0) {
                        $paymentLabel = 'Partial payment';
                        $paymentClass = 'badge-partial';
                        $due = max($priceTotal - $amountPaid, 0);
                    } else {
                        $paymentLabel = 'Unpaid';
                        $paymentClass = 'badge-unpaid';
                        $due = $priceTotal;
                    }
                } else {
                    if ($paidFlag) {
                        $paymentLabel = 'Paid (no amount set)';
                        $paymentClass = 'badge-paid';
                    }
                }

                // Ticket badge class
                $ticketBadgeClass = 'badge-single';
                if     ($pricing === 'double') $ticketBadgeClass = 'badge-double';
                elseif ($pricing === 'triple') $ticketBadgeClass = 'badge-triple';
                elseif ($pricing === 'custom') $ticketBadgeClass = 'badge-custom';

                // Card URL + WhatsApp link
                $url = $base . '/guest.php?token=' . $g['token'];
                $waLink  = 'https://wa.me/' . preg_replace('/[^0-9]/', '', $g['phone']) .
                    '?text=' . urlencode(
                        "Habari " . $g['name'] . ",\n" .
                        "Huu ni mwaliko wako kupitia TUMESSE EVENTS.\n" .
                        "Bofya hapa kuona kadi yako: " . $url
                    );
            ?>
            <tr>
                <td><?= (int)$g['id'] ?></td>

                <td>
                    <strong><?= htmlspecialchars($g['name']) ?></strong><br>
                    <span class="pill-label">
                        Created: <?= htmlspecialchars($g['created_at']) ?>
                    </span>
                </td>

                <td>
                    <?= htmlspecialchars($g['phone']) ?><br>
                    <?php if (!empty($g['email'])): ?>
                        <span class="pill-label"><?= htmlspecialchars($g['email']) ?></span>
                    <?php endif; ?>
                </td>

                <td>
                    <span class="badge <?= $ticketBadgeClass ?>">
                        <?= htmlspecialchars(ucfirst($pricing)) ?>
                    </span><br>
                    <span class="pill-label">
                        <?= $people . ' ' . ($people === 1 ? 'person' : 'people') ?>
                    </span>
                </td>

                <td><?= htmlspecialchars($template) ?></td>

                <td>
                    <span class="badge <?= $paymentClass ?>">
                        <?= htmlspecialchars($paymentLabel) ?>
                    </span>
                    <?php if ($priceTotal !== null && $priceTotal > 0): ?>
                        <br>
                        <span class="pill-label">
                            Total: <?= number_format($priceTotal, 0) ?> ·
                            Paid: <?= number_format($amountPaid, 0) ?> ·
                            Due: <?= number_format($due, 0) ?>
                        </span>
                    <?php endif; ?>
                    <br>
                    <a href="guest_payment.php?id=<?= (int)$g['id'] ?>">Add / Update payment</a>
                </td>

                <td>
                    <?php if (!empty($g['used'])): ?>
                        <span class="badge badge-used">Checked-in</span><br>
                        <span class="pill-label">
                            <?= htmlspecialchars($g['used_at']) ?>
                        </span>
                    <?php else: ?>
                        <span class="badge badge-notused">Not yet</span>
                    <?php endif; ?>
                </td>

                <td>
                    <a href="<?= $url ?>" target="_blank">View Card</a><br>
                    <a href="send_sms.php?id=<?= (int)$g['id'] ?>">Send SMS</a><br>
                    <a href="<?= $waLink ?>" target="_blank">WhatsApp</a>
                </td>

                <td>
                    <a href="edit_guest.php?id=<?= (int)$g['id'] ?>">Edit</a><br>
                    <a href="toggle_paid.php?id=<?= (int)$g['id'] ?>">Toggle Paid</a><br>
                    <a href="resend.php?id=<?= (int)$g['id'] ?>">Resend SMS</a><br>
                    <!-- NEW: Delete guest -->
                    <a href="delete_guest.php?id=<?= (int)$g['id'] ?>"
                       class="link-delete"
                       onclick="return confirm('Are you sure you want to delete this guest and their ticket?');">
                        Delete
                    </a>
                </td>
            </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>