<?php
require_once __DIR__ . '/_auth.php';

header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="guests_export_' . date('Ymd_His') . '.csv"');

// Open output stream
$out = fopen('php://output', 'w');

// CSV header
fputcsv($out, [
    'ID',
    'Name',
    'Phone',
    'Email',
    'Pricing',
    'Template',
    'Paid',
    'Checked_in',
    'Created_at',
    'Ticket_URL'
]);

$q     = trim($_GET['q'] ?? '');
$paid  = $_GET['paid'] ?? '';
$used  = $_GET['used'] ?? '';

$where  = [];
$params = [];

// Same filters as guests.php
if ($q !== '') {
    $where[] = "(name LIKE ? OR phone LIKE ? OR email LIKE ?)";
    $params[] = "%$q%";
    $params[] = "%$q%";
    $params[] = "%$q%";
}
if ($paid === '1' || $paid === '0') {
    $where[] = "paid = ?";
    $params[] = (int)$paid;
}
if ($used === '1' || $used === '0') {
    $where[] = "used = ?";
    $params[] = (int)$used;
}

$sql = "SELECT * FROM users";
if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY created_at DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

$base = rtrim($_ENV['BASE_URL'] ?? '', '/');

foreach ($rows as $g) {
    $ticketUrl = $base . '/guest.php?token=' . $g['token'];

    fputcsv($out, [
        $g['id'],
        $g['name'],
        $g['phone'],
        $g['email'],
        $g['pricing'],
        $g['template'],
        $g['paid'] ? '1' : '0',
        $g['used'] ? '1' : '0',
        $g['created_at'],
        $ticketUrl
    ]);
}

fclose($out);
exit;