<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/settings.php';

$eventName  = get_setting('event_name', 'TUMESSE EVENTS');
$eventDate  = get_setting('event_date', '');
$eventVenue = get_setting('event_venue', '');

$q     = trim($_GET['q'] ?? '');
$paid  = $_GET['paid'] ?? '';
$used  = $_GET['used'] ?? '';

$where  = [];
$params = [];

if ($q !== '') {
    $where[] = "(name LIKE ? OR phone LIKE ? OR email LIKE ?)";
    $params[] = "%$q%";
    $params[] = "%$q%";
    $params[] = "%$q%";
}
if ($paid === '1' || $paid === '0') {
    $where[] = "paid = ?";
    $params[] = (int)$paid;
}
if ($used === '1' || $used === '0') {
    $where[] = "used = ?";
    $params[] = (int)$used;
}

$sql = "SELECT * FROM users";
if ($where) {
    $sql .= " WHERE " . implode(" AND ", $where);
}
$sql .= " ORDER BY name ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Guest List – <?= htmlspecialchars($eventName) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        * { box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Poppins", Arial, sans-serif;
            margin: 20px;
            color: #222;
        }
        h1, h2, h3 {
            margin: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 12px;
        }
        .header small {
            color: #666;
            display: block;
            margin-top: 4px;
        }
        .meta {
            font-size: 0.85rem;
            margin-bottom: 10px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 0.82rem;
        }
        th, td {
            border: 1px solid #ccc;
            padding: 4px 6px;
            text-align: left;
        }
        th {
            background: #f3f3f8;
            font-weight: 600;
        }
        .badge {
            font-size: 0.76rem;
            padding: 1px 4px;
            border-radius: 4px;
        }
        .badge-paid { background:#e8f5e9;color:#2e7d32; }
        .badge-unpaid { background:#fff3e0;color:#ef6c00; }
        .badge-used { background:#e3f2fd;color:#1565c0; }
        .badge-notused { background:#f5f5f5;color:#616161; }

        @media print {
            body { margin: 10mm; }
            .no-print { display: none; }
        }
    </style>
</head>
<body>

<div class="no-print" style="margin-bottom:8px;text-align:right;">
    <button onclick="window.print();" style="padding:4px 10px;border-radius:6px;border:1px solid #ccc;cursor:pointer;">
        Print
    </button>
</div>

<div class="header">
    <h1><?= htmlspecialchars($eventName) ?></h1>
    <?php if ($eventDate): ?>
        <small>Date: <?= htmlspecialchars($eventDate) ?></small>
    <?php endif; ?>
    <?php if ($eventVenue): ?>
        <small>Venue: <?= htmlspecialchars($eventVenue) ?></small>
    <?php endif; ?>
</div>

<div class="meta">
    Printed at: <?= date('Y-m-d H:i') ?> &nbsp; | &nbsp;
    Total guests in this list: <strong><?= count($rows) ?></strong><br>
    Filters:
    <?php if ($q): ?> Search "<strong><?= htmlspecialchars($q) ?></strong>"<?php else: ?> None<?php endif; ?>,
    Payment: <?= $paid === '1' ? 'Paid only' : ($paid === '0' ? 'Unpaid only' : 'All') ?>,
    Check-in: <?= $used === '1' ? 'Checked-in only' : ($used === '0' ? 'Not yet only' : 'All') ?>
</div>

<table>
    <thead>
    <tr>
        <th>#</th>
        <th>Guest Name</th>
        <th>Phone</th>
        <th>Email</th>
        <th>Pricing</th>
        <th>Payment</th>
        <th>Check-in</th>
    </tr>
    </thead>
    <tbody>
    <?php if (!$rows): ?>
        <tr><td colspan="7">No guests for current filters.</td></tr>
    <?php else: ?>
        <?php $i = 1; foreach ($rows as $g): ?>
            <tr>
                <td><?= $i++ ?></td>
                <td><?= htmlspecialchars($g['name']) ?></td>
                <td><?= htmlspecialchars($g['phone']) ?></td>
                <td><?= htmlspecialchars($g['email']) ?></td>
                <td><?= htmlspecialchars(ucfirst($g['pricing'])) ?></td>
                <td>
                    <?php if ($g['paid']): ?>
                        <span class="badge badge-paid">Paid</span>
                    <?php else: ?>
                        <span class="badge badge-unpaid">Unpaid</span>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if ($g['used']): ?>
                        <span class="badge badge-used">Checked-in</span>
                    <?php else: ?>
                        <span class="badge badge-notused">Not yet</span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>
    </tbody>
</table>

</body>
</html>