<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$pageTitle  = 'RSVPs';
$activeMenu = 'rsvps';

$currentEventId = getCurrentEventId();

$stmt = $pdo->prepare("
    SELECT r.*, e.name AS event_name, e.event_date
    FROM rsvps r
    LEFT JOIN events e ON e.id = r.event_id
    WHERE r.event_id = ?
    ORDER BY r.id DESC
    LIMIT 300
");
$stmt->execute([$currentEventId]);
$rsvps = $stmt->fetchAll();

include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">RSVPs</h1>
    <p class="page-subtitle">
        Guests who confirmed attendance for the active event.
    </p>
</div>

<div class="card" style="overflow-x:auto;">
    <table style="width:100%;border-collapse:collapse;font-size:.86rem;">
        <thead>
        <tr>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">ID</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Guest</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Phone</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Message</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Created at</th>
        </tr>
        </thead>
        <tbody>
        <?php if (!$rsvps): ?>
            <tr>
                <td colspan="5" style="padding:18px 8px;text-align:center;color:#9ca3af;">
                    No RSVPs for this event yet.
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($rsvps as $r): ?>
                <tr>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;"><?= (int)$r['id'] ?></td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <strong><?= htmlspecialchars($r['name']) ?></strong><br>
                        <span class="pill-label">
                            Event: <?= htmlspecialchars($r['event_name'] ?? '') ?>
                            <?php if (!empty($r['event_date'])): ?>
                                (<?= htmlspecialchars($r['event_date']) ?>)
                            <?php endif; ?>
                        </span>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?= htmlspecialchars($r['phone']) ?>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;max-width:260px;">
                        <div style="max-height:80px;overflow:auto;white-space:pre-wrap;">
                            <?= htmlspecialchars($r['message']) ?>
                        </div>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?= htmlspecialchars($r['created_at']) ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>