<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';
require_once __DIR__ . '/../src/events.php';

$pageTitle  = 'SMS Logs';
$activeMenu = 'sms_logs';

$currentEventId = getCurrentEventId();

// latest 200 sends, show guest + status
$stmt = $pdo->prepare("
    SELECT s.*, u.name AS guest_name, u.phone AS guest_phone
    FROM sends s
    LEFT JOIN users u ON u.id = s.user_id
    WHERE s.channel LIKE 'sms%'
    ORDER BY s.id DESC
    LIMIT 200
");
$stmt->execute();
$logs = $stmt->fetchAll();

include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">SMS Logs</h1>
    <p class="page-subtitle">
        Recent SMS activities (bulk and individual). Latest 200 entries.
    </p>
</div>

<div class="card" style="overflow-x:auto;">
    <table style="width:100%;border-collapse:collapse;font-size:.86rem;">
        <thead>
        <tr>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">ID</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Guest</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Channel</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Message</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Status</th>
            <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Created</th>
        </tr>
        </thead>
        <tbody>
        <?php if (!$logs): ?>
            <tr>
                <td colspan="6" style="padding:18px 8px;text-align:center;color:#9ca3af;">
                    No SMS logs yet.
                </td>
            </tr>
        <?php else: ?>
            <?php foreach ($logs as $log): ?>
                <tr>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;"><?= (int)$log['id'] ?></td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?php if ($log['guest_name']): ?>
                            <strong><?= htmlspecialchars($log['guest_name']) ?></strong><br>
                            <span class="pill-label"><?= htmlspecialchars($log['guest_phone']) ?></span>
                        <?php else: ?>
                            <span class="pill-label">Unknown / direct phone</span>
                        <?php endif; ?>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?= htmlspecialchars($log['channel']) ?>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;max-width:260px;">
                        <div style="max-height:80px;overflow:auto;white-space:pre-wrap;">
                            <?= htmlspecialchars($log['payload']) ?>
                        </div>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?php if ($log['status'] === 'sent'): ?>
                            <span class="badge badge-paid">Sent</span>
                        <?php else: ?>
                            <span class="badge badge-unpaid"><?= htmlspecialchars($log['status']) ?></span>
                        <?php endif; ?>
                    </td>
                    <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;">
                        <?= htmlspecialchars($log['created_at'] ?? '') ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>