<?php
require_once __DIR__ . '/_auth.php';
require_once __DIR__ . '/../src/db.php';

$pageTitle  = 'SMS Templates';
$activeMenu = 'sms_templates';

$msg = '';
$err = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? 'create';

    if ($action === 'create') {
        $name = trim($_POST['name'] ?? '');
        $body = trim($_POST['body'] ?? '');
        $isDefault = isset($_POST['is_default']) ? 1 : 0;

        if (!$name || !$body) {
            $err = 'Template name and body are required.';
        } else {
            if ($isDefault) {
                $pdo->exec("UPDATE sms_templates SET is_default = 0");
            }

            $stmt = $pdo->prepare("INSERT INTO sms_templates (name, body, is_default) VALUES (?, ?, ?)");
            $stmt->execute([$name, $body, $isDefault]);
            $msg = 'Template created.';
        }
    } elseif ($action === 'update') {
        $id = (int)($_POST['id'] ?? 0);
        $name = trim($_POST['name'] ?? '');
        $body = trim($_POST['body'] ?? '');
        $isDefault = isset($_POST['is_default']) ? 1 : 0;

        if ($id <= 0 || !$name || !$body) {
            $err = 'Invalid template data.';
        } else {
            if ($isDefault) {
                $pdo->exec("UPDATE sms_templates SET is_default = 0");
            }

            $stmt = $pdo->prepare("UPDATE sms_templates SET name = ?, body = ?, is_default = ?, updated_at = NOW() WHERE id = ?");
            $stmt->execute([$name, $body, $isDefault, $id]);
            $msg = 'Template updated.';
        }
    }
}

// Delete via GET ?delete=
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    if ($id > 0) {
        $pdo->prepare("DELETE FROM sms_templates WHERE id = ?")->execute([$id]);
        $msg = 'Template deleted.';
    }
}

$templates = $pdo->query("SELECT * FROM sms_templates ORDER BY is_default DESC, id DESC")->fetchAll();

include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">SMS Templates</h1>
    <p class="page-subtitle">
        Manage reusable SMS messages. Use <code>{name}</code> and <code>{link}</code> placeholders in your content.
    </p>
</div>

<div class="card" style="max-width:780px;margin-bottom:16px;">
    <?php if ($msg): ?>
        <div style="background:#e0f2fe;border:1px solid #bfdbfe;color:#1d4ed8;padding:8px 10px;border-radius:8px;font-size:.85rem;margin-bottom:12px;">
            <?= htmlspecialchars($msg) ?>
        </div>
    <?php endif; ?>
    <?php if ($err): ?>
        <div style="background:#fee2e2;border:1px solid #fecaca;color:#b91c1c;padding:8px 10px;border-radius:8px;font-size:.85rem;margin-bottom:12px;">
            <?= htmlspecialchars($err) ?>
        </div>
    <?php endif; ?>

    <h3 style="margin-top:0;margin-bottom:8px;font-size:1rem;">Create new template</h3>
    <form method="post" style="display:flex;flex-direction:column;gap:8px;">
        <input type="hidden" name="action" value="create">
        <div class="grid" style="grid-template-columns:2fr 1fr;gap:10px;">
            <div>
                <label style="font-size:.85rem;">Name</label><br>
                <input type="text" name="name" required
                       style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;">
            </div>
            <div style="display:flex;align-items:flex-end;">
                <label style="font-size:.82rem;">
                    <input type="checkbox" name="is_default" value="1">
                    Set as default template
                </label>
            </div>
        </div>
        <div>
            <label style="font-size:.85rem;">Body</label><br>
            <textarea name="body" rows="4" required
                      placeholder="Habari {name},&#10;Huu ni mwaliko wako kwa tukio letu. Bofya {link} kuona kadi yako."
                      style="width:100%;padding:7px 9px;border-radius:8px;border:1px solid #d5d8e5;font-family:inherit;font-size:.9rem;"></textarea>
        </div>
        <div>
            <button class="btn-action primary" type="submit">Save Template</button>
        </div>
    </form>
</div>

<div class="card">
    <h3 style="margin-top:0;margin-bottom:8px;font-size:1rem;">Existing templates</h3>
    <?php if (!$templates): ?>
        <p style="font-size:.86rem;color:#6b7280;">No templates created yet.</p>
    <?php else: ?>
        <div style="overflow-x:auto;">
            <table style="width:100%;border-collapse:collapse;font-size:.86rem;">
                <thead>
                <tr>
                    <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Name</th>
                    <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Body</th>
                    <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Default</th>
                    <th style="padding:7px 8px;border-bottom:1px solid #e5e7eb;text-align:left;">Actions</th>
                </tr>
                </thead>
                <tbody>
                <?php foreach ($templates as $tpl): ?>
                    <tr>
                        <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;vertical-align:top;">
                            <strong><?= htmlspecialchars($tpl['name']) ?></strong>
                        </td>
                        <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;vertical-align:top;">
                            <pre style="margin:0;font-family:inherit;white-space:pre-wrap;"><?= htmlspecialchars($tpl['body']) ?></pre>
                        </td>
                        <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;vertical-align:top;">
                            <?= $tpl['is_default'] ? '<span class="badge badge-paid">Default</span>' : '' ?>
                        </td>
                        <td style="padding:7px 8px;border-bottom:1px solid #e5e7eb;vertical-align:top;">
                            <details>
                                <summary style="cursor:pointer;font-size:.82rem;color:#2563eb;">Edit</summary>
                                <form method="post" style="margin-top:6px;font-size:.82rem;display:flex;flex-direction:column;gap:6px;">
                                    <input type="hidden" name="action" value="update">
                                    <input type="hidden" name="id" value="<?= (int)$tpl['id'] ?>">
                                    <div>
                                        <label>Name</label><br>
                                        <input type="text" name="name"
                                               value="<?= htmlspecialchars($tpl['name']) ?>"
                                               style="width:100%;padding:5px 7px;border-radius:6px;border:1px solid #d5d8e5;">
                                    </div>
                                    <div>
                                        <label>Body</label><br>
                                        <textarea name="body" rows="3"
                                                  style="width:100%;padding:5px 7px;border-radius:6px;border:1px solid #d5d8e5;font-family:inherit;"><?= htmlspecialchars($tpl['body']) ?></textarea>
                                    </div>
                                    <div>
                                        <label style="font-size:.8rem;">
                                            <input type="checkbox" name="is_default" value="1" <?= $tpl['is_default'] ? 'checked' : '' ?>>
                                            Set as default
                                        </label>
                                    </div>
                                    <div style="display:flex;gap:6px;">
                                        <button class="btn-action primary" type="submit">Save</button>
                                        <a href="sms_templates.php?delete=<?= (int)$tpl['id'] ?>"
                                           class="btn-action"
                                           style="border-color:#fecaca;color:#b91c1c;"
                                           onclick="return confirm('Delete this template?');">
                                            Delete
                                        </a>
                                    </div>
                                </form>
                            </details>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>