<?php
require_once __DIR__ . '/_auth.php';

$templates = [
    'card_minimal' => 'Clean, simple white layout – great for general use.',
    'card_photo'   => 'Background photo style – you can replace with your own image.',
    'card_elegant' => 'Soft elegant border – perfect for classic wedding feel.',
    'card_modern'  => 'Modern “Save the Date” style.',
    'card_mahemba'  => 'Modern “Kuomba michango” style.',
    'card_dark'    => 'Dark night style, good for evening events.'

];

$pageTitle  = 'Card Templates';
$activeMenu = 'templates';
include __DIR__ . '/_layout_top.php';
?>

<div>
    <h1 class="page-heading">Card Templates</h1>
    <p class="page-subtitle">
        These templates are used when generating the online invitation card (E-card) for each guest.
        You can select a template per guest in the Add / Edit Guest pages.
    </p>
</div>

<div class="card">
    <div class="card-title">Available Templates</div>
    <p style="font-size:.85rem;color:#777;margin-bottom:10px;">
        To customize a template, edit the corresponding file in the <code>/templates/</code> folder
        (for example <code>card_elegant.php</code>) and adjust texts, colors or layout to match your theme.
    </p>

    <table>
        <thead>
        <tr>
            <th>Template Key</th>
            <th>Description</th>
            <th>File</th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($templates as $key => $desc): ?>
            <tr>
                <td><strong><?= htmlspecialchars($key) ?></strong></td>
                <td><?= htmlspecialchars($desc) ?></td>
                <td><code>templates/<?= htmlspecialchars($key) ?>.php</code></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include __DIR__ . '/_layout_bottom.php'; ?>