<?php
// public/_front_layout_top.php
require_once __DIR__ . '/../src/settings.php';
require_once __DIR__ . '/../src/events.php';

$siteTitle = get_setting('event_name', 'TUMESSE EVENTS');
if (!isset($pageTitle)) {
    $pageTitle = $siteTitle . ' – Digital Invitations & Gate Control';
}

$events     = getAllEvents();
$currentId  = getCurrentEventId();
$currentEvt = null;
foreach ($events as $e) {
    if ((int)$e['id'] === $currentId) {
        $currentEvt = $e;
        break;
    }
}
?>
<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($pageTitle) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@500;600&family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">

    <style>
        *{box-sizing:border-box;}
        body{
            margin:0;
            font-family:"Poppins",system-ui,-apple-system,BlinkMacSystemFont,sans-serif;
            background:#0f172a;
            color:#e5e7eb;
        }
        a{text-decoration:none;color:inherit;}
        .front-shell{
            min-height:100vh;
            background:
                radial-gradient(circle at top left,rgba(234,179,8,0.12),transparent 55%),
                radial-gradient(circle at bottom right,rgba(56,189,248,0.18),transparent 55%),
                #020617;
        }
        .front-max{
            width:100%;
            max-width:1120px;
            margin:0 auto;
            padding:18px 16px 40px;
        }

        /* HEADER */
        header.front-header{
            display:flex;
            align-items:center;
            justify-content:space-between;
            gap:14px;
            margin-bottom:18px;
        }
        .brand-mark{
            display:flex;
            align-items:center;
            gap:10px;
        }
        .brand-logo{
            width:34px;height:34px;border-radius:999px;
            border:2px solid rgba(250,250,250,.8);
            display:flex;align-items:center;justify-content:center;
            font-family:"Playfair Display",serif;
            font-weight:600;font-size:1.1rem;
            background:linear-gradient(135deg,#facc15,#fb923c);
            color:#111827;
        }
        .brand-text-main{
            font-weight:600;
            letter-spacing:.14em;
            font-size:.82rem;
            text-transform:uppercase;
        }
        .brand-text-sub{
            font-size:.7rem;
            color:#9ca3af;
        }
        nav.front-nav{
            display:flex;
            gap:12px;
            font-size:.8rem;
            color:#cbd5f5;
        }
        nav.front-nav a{
            padding:6px 10px;border-radius:999px;
            border:1px solid transparent;
        }
        nav.front-nav a:hover{
            border-color:rgba(148,163,184,.6);
            background:rgba(15,23,42,.7);
        }

        /* HERO + SLIDER */
        .hero{
            display:grid;
            grid-template-columns:minmax(0,1.2fr) minmax(0,1fr);
            gap:26px;
            margin-top:18px;
            margin-bottom:28px;
        }
        @media(max-width:800px){
            .hero{grid-template-columns:1fr;}
        }
        .hero-title{
            font-family:"Playfair Display",serif;
            font-weight:600;
            font-size:2.1rem;
            letter-spacing:.05em;
            text-transform:uppercase;
        }
        .hero-highlight{color:#facc15;}
        .hero-sub{
            margin-top:8px;
            font-size:.93rem;
            color:#cbd5f5;
        }
        .hero-tags{
            margin-top:10px;
            display:flex;
            flex-wrap:wrap;
            gap:8px;
            font-size:.75rem;
        }
        .hero-tag{
            padding:3px 10px;
            border-radius:999px;
            border:1px solid rgba(148,163,184,.5);
            color:#e5e7eb;
        }
        .hero-cta{
            margin-top:14px;
            display:flex;
            flex-wrap:wrap;
            gap:10px;
        }
        .btn-main{
            display:inline-flex;
            align-items:center;
            justify-content:center;
            padding:8px 15px;
            border-radius:999px;
            font-size:.85rem;
            font-weight:500;
            border:none;
            background:linear-gradient(135deg,#facc15,#fb923c);
            color:#111827;
            box-shadow:0 16px 40px rgba(248,250,252,.1);
            cursor:pointer;
        }
        .btn-ghost{
            display:inline-flex;
            align-items:center;
            justify-content:center;
            padding:7px 13px;
            border-radius:999px;
            font-size:.82rem;
            border:1px solid rgba(148,163,184,.7);
            background:rgba(15,23,42,.7);
            color:#e5e7eb;
            cursor:pointer;
        }
        .btn-main:hover{filter:brightness(1.03);}
        .btn-ghost:hover{background:rgba(15,23,42,.9);}

        .hero-card{
            border-radius:20px;
            border:1px solid rgba(148,163,184,.5);
            background:linear-gradient(145deg,rgba(15,23,42,.96),rgba(30,64,175,.85));
            padding:16px 16px 14px;
            box-shadow:0 18px 48px rgba(15,23,42,.65);
            font-size:.82rem;
            position:relative;
            overflow:hidden;
        }

        .hero-slider{
            position:relative;
            border-radius:16px;
            overflow:hidden;
            margin-top:10px;
        }
        .hero-slide{
            display:none;
            padding:10px 10px 12px;
            background:rgba(15,23,42,.8);
        }
        .hero-slide.active{display:block;}
        .hero-slide-title{
            font-family:"Playfair Display",serif;
            font-size:1rem;
            margin-bottom:2px;
        }
        .hero-slide-meta{
            font-size:.78rem;
            color:#9ca3af;
        }
        .hero-slide-indicators{
            position:absolute;
            right:10px;
            bottom:8px;
            display:flex;
            gap:4px;
        }
        .hero-indicator-dot{
            width:7px;height:7px;border-radius:999px;
            background:rgba(148,163,184,.6);
        }
        .hero-indicator-dot.active{background:#facc15;}

        /* COUNTDOWN */
        .countdown{
            margin-top:10px;
            display:flex;
            gap:8px;
            flex-wrap:wrap;
            font-size:.76rem;
        }
        .countdown-label{color:#9ca3af;}
        .countdown-boxes{
            display:flex;
            gap:6px;
        }
        .countdown-item{
            min-width:40px;
            padding:4px 6px;
            border-radius:8px;
            background:rgba(15,23,42,.9);
            border:1px solid rgba(148,163,184,.6);
            text-align:center;
        }
        .countdown-item strong{display:block;font-size:.9rem;}

        /* SECTIONS */
        .section-block{
            margin-top:28px;
            margin-bottom:6px;
        }
        .section-title{
            font-size:1rem;
            font-weight:500;
            margin:0 0 6px;
        }
        .section-sub{
            font-size:.82rem;color:#9ca3af;margin:0 0 10px;
        }

        .events-grid{
            display:grid;
            grid-template-columns:repeat(auto-fit,minmax(230px,1fr));
            gap:12px;
        }
        .event-card{
            border-radius:14px;
            background:rgba(15,23,42,.9);
            border:1px solid rgba(148,163,184,.5);
            padding:10px 11px 9px;
            font-size:.82rem;
        }
        .event-chip{
            font-size:.7rem;
            text-transform:uppercase;
            letter-spacing:.12em;
            color:#a5b4fc;
        }
        .event-name{
            margin-top:4px;
            font-weight:500;
        }
        .event-meta{
            margin-top:4px;
            color:#9ca3af;
        }

        .about-grid{
            display:grid;
            grid-template-columns:minmax(0,1.2fr) minmax(0,1fr);
            gap:16px;
        }
        @media(max-width:800px){
            .about-grid{grid-template-columns:1fr;}
        }
        .about-highlight{
            font-size:.85rem;
            color:#facc15;
            text-transform:uppercase;
            letter-spacing:.18em;
        }
        .about-text{
            font-size:.86rem;
            color:#e5e7eb;
            line-height:1.6;
        }
        .about-panel{
            border-radius:16px;
            background:rgba(15,23,42,.9);
            border:1px solid rgba(148,163,184,.5);
            padding:12px 13px 11px;
            font-size:.8rem;
        }

        .card-light{
            background:#f9fafb;
            color:#111827;
            border-radius:18px;
            padding:14px 14px 16px;
            border:1px solid #e5e7eb;
        }
        .card-light h3{
            margin:0 0 6px;font-size:.98rem;
        }
        .card-light p{
            margin:0 0 8px;font-size:.85rem;color:#4b5563;
        }
        .rsvp-grid{
            display:grid;
            grid-template-columns: minmax(0,1.1fr) minmax(0,1fr);
            gap:14px;
        }
        @media(max-width:800px){
            .rsvp-grid{grid-template-columns:1fr;}
        }
        .rsvp-form label{
            font-size:.78rem;
            color:#4b5563;
        }
        .rsvp-form input,
        .rsvp-form textarea,
        .rsvp-form select{
            width:100%;
            margin-top:3px;
            margin-bottom:8px;
            padding:7px 9px;
            border-radius:8px;
            border:1px solid #d1d5db;
            font-size:.86rem;
            font-family:inherit;
        }
        .rsvp-form textarea{resize:vertical;min-height:72px;}

        .map-wrapper{
            border-radius:16px;
            overflow:hidden;
            border:1px solid #e5e7eb;
        }
        .map-wrapper iframe{
            display:block;
            width:100%;
            height:240px;
            border:0;
        }

        /* COUPLE SECTION */
        .couple-grid{
            display:grid;
            grid-template-columns: minmax(0,1.2fr) minmax(0,1fr);
            gap:16px;
        }
        @media(max-width:800px){
            .couple-grid{grid-template-columns:1fr;}
        }
        .couple-card{
            border-radius:18px;
            padding:14px 14px 16px;
            border:1px solid rgba(148,163,184,.5);
            background:linear-gradient(160deg,rgba(15,23,42,.95),rgba(30,64,175,.9));
            display:flex;
            gap:12px;
            align-items:center;
        }
        .couple-photo{
            flex:0 0 80px;
            width:80px;height:80px;
            border-radius:999px;
            overflow:hidden;
            border:2px solid #facc15;
            background:#111827;
        }
        .couple-photo img{
            width:100%;height:100%;object-fit:cover;
        }
        .couple-text{
            font-size:.84rem;
            color:#e5e7eb;
        }
        .couple-names{
            font-family:"Playfair Display",serif;
            font-size:1.1rem;
            margin-bottom:4px;
        }

        /* GALLERY */
        .gallery-grid{
            display:grid;
            grid-template-columns:repeat(auto-fit,minmax(150px,1fr));
            gap:10px;
        }
        .gallery-item{
            border-radius:12px;
            overflow:hidden;
            border:1px solid rgba(148,163,184,.5);
            background:#020617;
        }
        .gallery-item img{
            width:100%;
            height:140px;
            object-fit:cover;
            display:block;
        }

        /* SPONSORS */
        .sponsors-strip{
            display:flex;
            flex-wrap:wrap;
            gap:12px;
            align-items:center;
            justify-content:flex-start;
        }
        .sponsor-badge{
            padding:6px 10px;
            border-radius:999px;
            border:1px solid #e5e7eb;
            background:#ffffff;
            display:flex;
            align-items:center;
            gap:6px;
            font-size:.8rem;
            color:#111827;
        }
        .sponsor-badge img{
            height:20px;
            width:auto;
        }

        footer.front-footer{
            margin-top:30px;
            font-size:.78rem;
            color:#9ca3af;
            text-align:right;
        }
        footer.front-footer strong{color:#e5e7eb;}
    </style>
</head>
<body>
<div class="front-shell">
<div class="front-max">
    <header class="front-header">
        <div class="brand-mark">
            <div class="brand-logo">T</div>
            <div>
                <div class="brand-text-main"><?= htmlspecialchars($siteTitle) ?></div>
                <div class="brand-text-sub">Smart invitations • Digital gate control</div>
            </div>
        </div>
        <nav class="front-nav">
            <a href="#home">Home</a>
            <a href="#about">About</a>
            <a href="#events">Events</a>
            <a href="#gallery">Gallery</a>
            <a href="#rsvp">RSVP</a>
            <a href="../admin/admin_login.php">Admin</a>
        </nav>
    </header>