<?php
require_once __DIR__ . '/../src/tickets.php';
require_once __DIR__ . '/../src/settings.php';

$token = $_GET['token'] ?? '';
if (!$token) {
    echo 'Invalid invitation link.';
    exit;
}

$user = getGuestByToken($token);
if (!$user) {
    echo 'Invitation not found.';
    exit;
}

// Event settings
$eventName  = get_setting('event_name', 'TUMESSE EVENTS');
$eventDate  = get_setting('event_date', '');
$eventVenue = get_setting('event_venue', '');
$eventTheme = get_setting('event_theme', '');

// Ticket URL (what QR should point to)
$baseUrl   = rtrim($_ENV['BASE_URL'] ?? '', '/');
$ticketUrl = $baseUrl . '/guest.php?token=' . $user['token'];

// Short ticket ID
$ticketId  = strtoupper(substr($user['token'], 0, 8));

// ✅ Generate QR image URL (NEW: using api.qrserver.com)
$qr = 'https://api.qrserver.com/v1/create-qr-code/?size=220x220&data=' . urlencode($ticketUrl);

// Pick template file
$templateFile = __DIR__ . '/../templates/' . ($user['template'] ?? 'card_minimal') . '.php';
if (!file_exists($templateFile)) {
    $templateFile = __DIR__ . '/../templates/card_minimal.php';
}

include $templateFile;