<?php
$pageTitle = 'TUMESSE EVENTS – Digital invitations & gate control';
require_once __DIR__ . '/_front_layout_top.php';

// Get map embed code from settings if you want (optional)
$mapEmbed = get_setting('event_map_embed', '');

// Prepare latest & upcoming events
$today = new DateTimeImmutable('today');
$upcomingEvents = [];
$pastEvents = [];

foreach ($events as $ev) {
    if (empty($ev['event_date'])) {
        $upcomingEvents[] = $ev;
        continue;
    }
    try {
        $d = new DateTimeImmutable($ev['event_date']);
    } catch (Exception $e) {
        $upcomingEvents[] = $ev;
        continue;
    }
    if ($d >= $today) {
        $upcomingEvents[] = $ev;
    } else {
        $pastEvents[] = $ev;
    }
}
$latestEvents = array_slice(array_reverse($pastEvents), 0, 3);

// Countdown target
$countdownDate = '';
if (!empty($currentEvt['event_date'])) {
    $countdownDate = $currentEvt['event_date'] . ' 00:00:00';
}
?>

<a id="home"></a>
<section class="hero">
    <div>
        <div class="hero-title">
            Elegant <span class="hero-highlight">digital invitations</span><br>
            for your special day
        </div>
        <p class="hero-sub">
            Send personalised e-cards via SMS & WhatsApp, track payments,
            and verify every guest at the gate using QR codes – all from one
            simple system built for your wedding and events.
        </p>
        <div class="hero-tags">
            <div class="hero-tag">SMS & WhatsApp invitations</div>
            <div class="hero-tag">QR gate scanning</div>
            <div class="hero-tag">Multi-event support</div>
            <div class="hero-tag">Powered by TekiSOFT</div>
        </div>
        <div class="hero-cta">
            <a class="btn-main" href="../admin/admin_login.php">Go to Admin Dashboard</a>
            <a class="btn-ghost" href="scanner.html" target="_blank">Open Gate Scanner</a>
        </div>

        <?php if ($countdownDate): ?>
            <div class="countdown" data-countdown="<?= htmlspecialchars($countdownDate) ?>">
                <div class="countdown-label">Countdown to event</div>
                <div class="countdown-boxes">
                    <div class="countdown-item">
                        <strong id="cd-days">0</strong>
                        <span>Days</span>
                    </div>
                    <div class="countdown-item">
                        <strong id="cd-hours">0</strong>
                        <span>Hrs</span>
                    </div>
                    <div class="countdown-item">
                        <strong id="cd-mins">0</strong>
                        <span>Mins</span>
                    </div>
                    <div class="countdown-item">
                        <strong id="cd-secs">0</strong>
                        <span>Sec</span>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <div class="hero-card">
        <div class="hero-card-title">Current event snapshot</div>
        <?php if ($currentEvt): ?>
            <div class="hero-card-sub">You are viewing the active event.</div>
            <div style="font-size:.78rem;">
                <div><strong><?= htmlspecialchars($currentEvt['name']) ?></strong></div>
                <?php if (!empty($currentEvt['event_date'])): ?>
                    <div><?= htmlspecialchars($currentEvt['event_date']) ?></div>
                <?php endif; ?>
                <?php if (!empty($currentEvt['venue'])): ?>
                    <div><?= htmlspecialchars($currentEvt['venue']) ?></div>
                <?php endif; ?>
                <?php if (!empty($currentEvt['theme'])): ?>
                    <div style="margin-top:4px;color:#e5e7eb;">
                        Theme: <span style="color:#fde68a;"><?= htmlspecialchars($currentEvt['theme']) ?></span>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="hero-card-sub">
                No event is configured yet. Login as admin to create one.
            </div>
        <?php endif; ?>

        <!-- Simple home slideshow (3 slides) -->
        <div class="hero-slider" data-slider>
            <div class="hero-slide active">
                <div class="hero-slide-title">Digital wedding invitations</div>
                <div class="hero-slide-meta">
                    Guests receive a personalised card with QR code and event details,
                    straight to their phone.
                </div>
            </div>
            <div class="hero-slide">
                <div class="hero-slide-title">Smart guest management</div>
                <div class="hero-slide-meta">
                    View payments, RSVPs and ticket usage in real time from your dashboard.
                </div>
            </div>
            <div class="hero-slide">
                <div class="hero-slide-title">Fast gate check-in</div>
                <div class="hero-slide-meta">
                    Staff at the venue scan QR codes and confirm entry instantly –
                    no paper required.
                </div>
            </div>

            <div class="hero-slide-indicators">
                <div class="hero-indicator-dot active"></div>
                <div class="hero-indicator-dot"></div>
                <div class="hero-indicator-dot"></div>
            </div>
        </div>
    </div>
</section>

<a id="about"></a>
<section class="section-block">
    <h2 class="section-title">About TUMESSE EVENTS</h2>
    <p class="section-sub">
        A modern way to manage wedding invitations, guests and gate access – built in Tanzania by TekiSOFT.
    </p>

    <div class="about-grid">
        <div>
            <div class="about-highlight">WHO WE ARE</div>
            <p class="about-text">
                TUMESSE EVENTS is a lightweight but powerful platform designed to simplify wedding
                and event invitations. Instead of printing hundreds of paper cards, you create a
                beautiful digital card once, send it via SMS or WhatsApp, and track everything from
                your dashboard.
            </p>
            <p class="about-text">
                The system is built with real Tanzanian events in mind – contributions, single or
                double tickets, partial payments and strict gate control. Your guests enjoy a smooth
                digital experience, while you enjoy clear reports and peace of mind.
            </p>
        </div>
        <div class="about-panel">
            <div style="font-size:.82rem;margin-bottom:6px;font-weight:500;">Why hosts love TUMESSE:</div>
            <ul style="margin:0 0 8px 18px;padding:0;font-size:.82rem;color:#e5e7eb;">
                <li>Digital invitation cards with QR codes</li>
                <li>Support for single, double, triple and custom tickets</li>
                <li>Full &amp; partial payment tracking per guest</li>
                <li>Bulk SMS reminders via Beem Africa</li>
                <li>Multi-event support in one system</li>
                <li>Professional reports &amp; CSV exports</li>
            </ul>
            <div style="font-size:.78rem;color:#9ca3af;">
                Developed and powered by <strong>TekiSOFT</strong>.
            </div>
        </div>
    </div>
</section>

<a id="events"></a>
<section class="section-block">
    <h2 class="section-title">Upcoming events</h2>
    <p class="section-sub">
        Events that are still ahead. The highlighted one is currently active in the system.
    </p>
    <div class="events-grid">
        <?php if (!$upcomingEvents): ?>
            <div class="event-card">
                <div class="event-chip">No events</div>
                <div class="event-name">No upcoming events configured.</div>
            </div>
        <?php else: ?>
            <?php foreach ($upcomingEvents as $ev): ?>
                <div class="event-card" style="<?= (int)$ev['id']===$currentId ? 'border-color:#facc15;' : '' ?>">
                    <div class="event-chip">
                        <?= (int)$ev['id']===$currentId ? 'Active event' : 'Upcoming' ?>
                    </div>
                    <div class="event-name"><?= htmlspecialchars($ev['name']) ?></div>
                    <div class="event-meta">
                        <?php if (!empty($ev['event_date'])): ?>
                            <div><?= htmlspecialchars($ev['event_date']) ?></div>
                        <?php endif; ?>
                        <?php if (!empty($ev['venue'])): ?>
                            <div><?= htmlspecialchars($ev['venue']) ?></div>
                        <?php endif; ?>
                        <?php if (!empty($ev['theme'])): ?>
                            <div>Theme: <?= htmlspecialchars($ev['theme']) ?></div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <?php if ($latestEvents): ?>
        <div style="margin-top:20px;">
            <h3 class="section-title" style="font-size:.95rem;">Latest past events</h3>
            <p class="section-sub">A quick look at a few recent events handled by the system.</p>
            <div class="events-grid">
                <?php foreach ($latestEvents as $ev): ?>
                    <div class="event-card">
                        <div class="event-chip">Completed</div>
                        <div class="event-name"><?= htmlspecialchars($ev['name']) ?></div>
                        <div class="event-meta">
                            <?php if (!empty($ev['event_date'])): ?>
                                <div><?= htmlspecialchars($ev['event_date']) ?></div>
                            <?php endif; ?>
                            <?php if (!empty($ev['venue'])): ?>
                                <div><?= htmlspecialchars($ev['venue']) ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</section>

<a id="rsvp"></a>
<section class="section-block">
    <div class="card-light">
        <div class="rsvp-grid">
            <div>
                <h3>Confirm your presence (RSVP)</h3>
                <p>
                    Guests can use this form to confirm that they will attend.
                    Responses are saved to the system so organisers can plan seats,
                    food and logistics.
                </p>
                <ul style="margin:0 0 8px 18px;padding:0;font-size:.84rem;color:#4b5563;">
                    <li>Choose the event you will attend</li>
                    <li>Enter your name and phone number</li>
                    <li>Optionally write a note or special request</li>
                </ul>
                <p style="font-size:.8rem;color:#6b7280;">
                    <strong>Note:</strong> This does not replace the digital ticket;
                    guests will still need their QR invitation at the gate.
                </p>
            </div>
            <div>
                <?php if (!empty($_GET['rsvp']) && $_GET['rsvp']==='ok'): ?>
                    <div style="background:#ecfdf3;border:1px solid #bbf7d0;color:#166534;padding:7px 9px;border-radius:8px;font-size:.82rem;margin-bottom:8px;">
                        Asante! RSVP yako imepokelewa vizuri.
                    </div>
                <?php endif; ?>

                <form class="rsvp-form" action="rsvp_submit.php" method="post">
                    <label>Event</label>
                    <select name="event_id" required>
                        <?php foreach ($events as $ev): ?>
                            <option value="<?= (int)$ev['id'] ?>" <?= (int)$ev['id']===$currentId ? 'selected' : '' ?>>
                                <?= htmlspecialchars($ev['name']) ?>
                                <?php if (!empty($ev['event_date'])): ?>
                                    (<?= htmlspecialchars($ev['event_date']) ?>)
                                <?php endif; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>

                    <label>Full name</label>
                    <input type="text" name="name" required placeholder="Jina lako kamili">

                    <label>Phone number</label>
                    <input type="text" name="phone" required placeholder="Mfano: 07xxxxxxxx">

                    <label>Message (optional)</label>
                    <textarea name="message" placeholder="Tuma ujumbe mfupi au mahitaji maalum"></textarea>

                    <button type="submit" class="btn-main" style="margin-top:4px;">Send RSVP</button>
                </form>
            </div>
        </div>
    </div>
</section>

<section class="section-block">
    <h2 class="section-title">Venue map</h2>
    <p class="section-sub">
        Share the location of your current event so guests can easily find the venue.
    </p>
    <div class="map-wrapper">
        <?php if ($mapEmbed): ?>
            <?= $mapEmbed ?>
        <?php else: ?>
            <!-- Fallback example map (you can replace with your own embed HTML in settings) -->
            <iframe
                src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d8034.602259787927!2d39.237!3d-6.774!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2sMlimani%20City!5e0!3m2!1sen!2stz!4v1700000000000"
                loading="lazy"
                referrerpolicy="no-referrer-when-downgrade"></iframe>
        <?php endif; ?>
    </div>
</section>

<a id="gallery"></a>
<section class="section-block">
    <h2 class="section-title">Event gallery</h2>
    <p class="section-sub">
        A few highlight images for your event. Replace the image files in <code>public/assets/gallery-*.jpg</code>.
    </p>
    <div class="gallery-grid">
        <div class="gallery-item">
            <img src="assets/gallery-1.jpg" alt="Wedding highlight 1">
        </div>
        <div class="gallery-item">
            <img src="assets/gallery-2.jpg" alt="Wedding highlight 2">
        </div>
        <div class="gallery-item">
            <img src="assets/gallery-3.jpg" alt="Wedding highlight 3">
        </div>
        <div class="gallery-item">
            <img src="assets/gallery-4.jpg" alt="Wedding highlight 4">
        </div>
    </div>
</section>

<section class="section-block">
    <h2 class="section-title">The couple</h2>
    <p class="section-sub">
        Introduce the couple to your guests with a warm short story.
    </p>
    <div class="couple-grid">
        <div class="couple-card">
            <div class="couple-photo">
                <img src="assets/couple-main.jpg" alt="Wedding couple">
            </div>
            <div class="couple-text">
                <div class="couple-names">[Your Names Here]</div>
                <div>
                    Our story is a journey of grace, friendship and answered prayers.
                    On this special day we are honoured to celebrate with family and
                    friends who have walked with us. Karibu tusherehekee pamoja.
                </div>
            </div>
        </div>
        <div class="about-panel">
            <div style="font-size:.82rem;margin-bottom:4px;font-weight:500;">Message from the couple</div>
            <p style="margin:0 0 6px;font-size:.82rem;color:#e5e7eb;">
                “Your presence, prayers and support mean more than any gift.
                Thank you for being part of our story and helping us make this
                day unforgettable.”
            </p>
            <p style="margin:0;font-size:.8rem;color:#9ca3af;">
                You can edit this text and the couple photo by replacing the image files and updating
                <code>index.php</code>.
            </p>
        </div>
    </div>
</section>

<section class="section-block">
    <h2 class="section-title">Our partners & sponsors</h2>
    <p class="section-sub">
        Showcase businesses, family or friends who are supporting your event.
    </p>
    <div class="sponsors-strip">
        <div class="sponsor-badge">
            <img src="assets/sponsor-tekisoft.png" alt="TekiSOFT">
            <span>TekiSOFT</span>
        </div>
        <div class="sponsor-badge">
            <img src="assets/sponsor-1.png" alt="Sponsor 1">
            <span>Sponsor One</span>
        </div>
        <div class="sponsor-badge">
            <img src="assets/sponsor-2.png" alt="Sponsor 2">
            <span>Sponsor Two</span>
        </div>
        <div class="sponsor-badge">
            <img src="assets/sponsor-3.png" alt="Sponsor 3">
            <span>Sponsor Three</span>
        </div>
    </div>
</section>

<section id="how-it-works" class="section-block">
    <h2 class="section-title">How TUMESSE EVENTS works</h2>
    <p class="section-sub">
        A simple flow from invitation to gate verification.
    </p>

    <div class="events-grid">
        <div class="event-card">
            <div class="event-chip">Step 1</div>
            <div class="event-name">Create event & guest list</div>
            <div class="event-meta">
                Admin adds events, guests, ticket types (single, double, custom)
                and amounts in the dashboard.
            </div>
        </div>
        <div class="event-card">
            <div class="event-chip">Step 2</div>
            <div class="event-name">Send digital invitations</div>
            <div class="event-meta">
                Invitations are sent via SMS (Beem Africa) and WhatsApp links.
                Each guest receives a personalised e-card.
            </div>
        </div>
        <div class="event-card">
            <div class="event-chip">Step 3</div>
            <div class="event-name">Manage payments & RSVPs</div>
            <div class="event-meta">
                Track full or partial payments per guest, see totals, and follow up
                with automatic SMS reminders.
            </div>
        </div>
        <div class="event-card">
            <div class="event-chip">Step 4</div>
            <div class="event-name">Gate scanning & reporting</div>
            <div class="event-meta">
                At the venue, staff scan QR codes to confirm tickets. The dashboard
                shows live check-in statistics.
            </div>
        </div>
    </div>
</section>

<script>
// Simple hero slider
(function(){
    const slider = document.querySelector('[data-slider]');
    if (!slider) return;
    const slides = slider.querySelectorAll('.hero-slide');
    const dots   = slider.querySelectorAll('.hero-indicator-dot');
    let index = 0;

    function showSlide(i){
        slides.forEach((s,idx)=>s.classList.toggle('active', idx===i));
        dots.forEach((d,idx)=>d.classList.toggle('active', idx===i));
    }
    setInterval(()=>{
        if (!slides.length) return;
        index = (index+1) % slides.length;
        showSlide(index);
    }, 6000);
})();

// Countdown timer
(function(){
    const cd = document.querySelector('.countdown');
    if (!cd) return;
    const targetStr = cd.getAttribute('data-countdown');
    if (!targetStr) return;
    const target = new Date(targetStr).getTime();
    if (!target) return;

    const daysEl  = document.getElementById('cd-days');
    const hoursEl = document.getElementById('cd-hours');
    const minsEl  = document.getElementById('cd-mins');
    const secsEl  = document.getElementById('cd-secs');

    function tick(){
        const now = Date.now();
        let diff = Math.floor((target - now)/1000);
        if (diff < 0) diff = 0;

        const days  = Math.floor(diff / (24*3600));
        diff -= days*24*3600;
        const hours = Math.floor(diff / 3600);
        diff -= hours*3600;
        const mins  = Math.floor(diff / 60);
        const secs  = diff - mins*60;

        if (daysEl)  daysEl.textContent  = days;
        if (hoursEl) hoursEl.textContent = hours;
        if (minsEl)  minsEl.textContent  = mins;
        if (secsEl)  secsEl.textContent  = secs;
    }
    tick();
    setInterval(tick, 1000);
})();
</script>

<?php require __DIR__ . '/_front_layout_bottom.php'; ?>