<?php
require_once __DIR__ . '/../src/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: index.php');
    exit;
}

$eventId = (int)($_POST['event_id'] ?? 0);
$name    = trim($_POST['name'] ?? '');
$phone   = trim($_POST['phone'] ?? '');
$message = trim($_POST['message'] ?? '');

if ($eventId <= 0 || $name === '' || $phone === '') {
    header('Location: index.php');
    exit;
}

$stmt = $pdo->prepare("INSERT INTO rsvps (event_id, name, phone, message) VALUES (?, ?, ?, ?)");
$stmt->execute([$eventId, $name, $phone, $message ?: null]);

header('Location: index.php?rsvp=ok');
exit;