<?php
header('Content-Type: application/json');

require_once __DIR__ . '/../src/db.php';

// Scanned data (we expect it to be exactly the token)
$data = $_GET['data'] ?? '';
$data = trim($data);

if ($data === '') {
    echo json_encode([
        'status'  => 'error',
        'message' => 'No data scanned'
    ]);
    exit;
}

// Clean token (just in case)
$token = preg_replace('/[^a-zA-Z0-9]/', '', $data);
if ($token === '') {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Invalid token'
    ]);
    exit;
}

// Look up guest
$stmt = $pdo->prepare("SELECT * FROM users WHERE token = ? LIMIT 1");
$stmt->execute([$token]);
$guest = $stmt->fetch();

if (!$guest) {
    echo json_encode([
        'status'  => 'invalid',
        'message' => 'Ticket not found in system'
    ]);
    exit;
}

// Already used?
if (!empty($guest['used']) && !empty($guest['used_at'])) {
    echo json_encode([
        'status'        => 'used',
        'name'          => $guest['name'],
        'pricing'       => $guest['pricing'],
        'pricing_label' => ucfirst($guest['pricing']),
        'paid'          => (bool)$guest['paid'],
        'used_at'       => $guest['used_at'],
    ]);
    exit;
}

// Mark as used now
$pdo->query("SET time_zone = '+03:00'");
$upd = $pdo->prepare("UPDATE users SET used = 1, used_at = NOW() WHERE id = ?");
$upd->execute([$guest['id']]);

// Reload to get used_at
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ? LIMIT 1");
$stmt->execute([$guest['id']]);
$guest = $stmt->fetch();

echo json_encode([
    'status'        => 'ok',
    'name'          => $guest['name'],
    'pricing'       => $guest['pricing'],
        'pricing_label' => ucfirst($guest['pricing']),
        'paid'          => (bool)$guest['paid'],
        'used_at'       => $guest['used_at'],
]);