<?php

// Load .env file
function load_env($path) {
    $vars = [];

    if (!file_exists($path)) {
        return $vars;
    }

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($lines as $line) {
        $line = trim($line);

        // Ignore comments
        if ($line === '' || strpos($line, '#') === 0) {
            continue;
        }

        if (strpos($line, '=') !== false) {
            list($key, $value) = explode('=', $line, 2);
            $vars[trim($key)] = trim($value);
        }
    }

    return $vars;
}

// Load .env variables
$env = load_env(__DIR__ . '/../.env');

// Database credentials
$dbhost = $env['DB_HOST'] ?? 'localhost';
$dbname = $env['DB_NAME'] ?? 'wedding';
$dbuser = $env['DB_USER'] ?? 'root';
$dbpass = $env['DB_PASS'] ?? 'TekiPOS2025';

// PDO connection
try {
    $pdo = new PDO(
        "mysql:host={$dbhost};dbname={$dbname};charset=utf8mb4",
        $dbuser,
        $dbpass,
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        ]
    );
} catch (PDOException $e) {
    die("Database Connection Failed: " . $e->getMessage());
}

// Make all .env variables available in $_ENV[]
foreach ($env as $k => $v) {
    $_ENV[$k] = $v;
}