<?php
// src/events.php
require_once __DIR__ . '/db.php';

function getAllEvents(): array {
    global $pdo;
    $stmt = $pdo->query("SELECT * FROM events ORDER BY event_date DESC, id DESC");
    return $stmt->fetchAll();
}

function getEventById(int $id) {
    global $pdo;
    $stmt = $pdo->prepare("SELECT * FROM events WHERE id = ? LIMIT 1");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

/**
 * Global current event, stored in session.
 * - Reads ?event_id= from URL if present and stores in session
 * - Falls back to latest active event
 */
function getCurrentEventId(): int {
    if (session_status() === PHP_SESSION_NONE) {
        session_start();
    }

    if (isset($_GET['event_id'])) {
        $_SESSION['current_event_id'] = (int)$_GET['event_id'];
    }
    if (!empty($_SESSION['current_event_id'])) {
        return (int)$_SESSION['current_event_id'];
    }

    global $pdo;

    // Prefer active event
    $stmt = $pdo->query("SELECT id FROM events WHERE is_active = 1 ORDER BY event_date DESC, id DESC LIMIT 1");
    $row  = $stmt->fetch();
    if ($row) return (int)$row['id'];

    // Fallback: any event
    $stmt = $pdo->query("SELECT id FROM events ORDER BY id DESC LIMIT 1");
    $row  = $stmt->fetch();
    return $row ? (int)$row['id'] : 1;
}