<?php
// src/settings.php
require_once __DIR__ . '/db.php';

function get_setting(string $key, string $default = '') {
    global $pdo;
    static $cache = [];

    if (isset($cache[$key])) {
        return $cache[$key];
    }

    $stmt = $pdo->prepare("SELECT value FROM settings WHERE key_name = ? LIMIT 1");
    $stmt->execute([$key]);
    $value = $stmt->fetchColumn();

    if ($value === false) {
        return $default;
    }

    $cache[$key] = $value;
    return $value;
}