<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($eventName) ?> – Night Invitation for <?= htmlspecialchars($user['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body class="ecard-body ecard-dark">
<div class="ecard-shell">

    <div class="ecard-header">
        <div class="ecard-title"><?= htmlspecialchars($eventName) ?></div>
        <p class="ecard-subtitle">
            <?php if ($eventDate): ?>
                <span><?= htmlspecialchars($eventDate) ?></span>
            <?php endif; ?>
            <?php if ($eventVenue): ?>
                <span><?= htmlspecialchars($eventVenue) ?></span>
            <?php endif; ?>
        </p>
    </div>

    <div class="ecard-body-inner">
        <div>
            <div class="ecard-section-title">Evening Guest</div>
            <h2 class="ecard-guest-name"><?= htmlspecialchars($user['name']) ?></h2>
            <p class="ecard-text">
                You are invited to a memorable evening filled with joy and celebration.
            </p>

            <p class="ecard-text">
                Ticket type:
                <strong><?= htmlspecialchars(ucfirst($user['pricing'])) ?></strong>
            </p>

            <div class="ecard-pill">
                <span>Status:</span>
                <?php if ($user['paid']): ?>
                    <span class="badge badge-paid">Paid</span>
                <?php else: ?>
                    <span class="badge badge-unpaid">Pending</span>
                <?php endif; ?>
            </div>

            <?php if ($eventTheme): ?>
                <p class="ecard-text" style="margin-top:10px;">
                    Theme: <strong><?= htmlspecialchars($eventTheme) ?></strong>
                </p>
            <?php endif; ?>

            <p class="ecard-text" style="margin-top:12px;">
                Please bring this digital ticket on your phone. Screenshots are accepted.
            </p>
        </div>

        <div class="ecard-qr-box">
            <div class="ecard-qr-label">Scan at Gate</div>
            <img src="<?= htmlspecialchars($qr) ?>" alt="Ticket QR">
            <div class="ecard-ticket-id">
                Ticket ID: <strong><?= htmlspecialchars($ticketId) ?></strong>
            </div>
            <div class="ecard-note">
                Security & entry control will use this code to validate your access.
            </div>
        </div>
    </div>

    <div class="ecard-footer">
        <span>For any changes or questions, contact the event organizers.</span>
        <span>Powered by <strong>TekiSOFT · TUMESSE EVENTS</strong></span>
    </div>

</div>
</body>
</html>