<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($eventName) ?> – Invitation for <?= htmlspecialchars($user['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body class="ecard-body ecard-elegant">
<div class="ecard-shell">

    <div class="ecard-header">
        <div class="ecard-title">
            <?= htmlspecialchars($eventName) ?>
        </div>
        <p class="ecard-subtitle">
            <?php if ($eventDate): ?>
                <span><?= htmlspecialchars($eventDate) ?></span>
            <?php endif; ?>
            <?php if ($eventVenue): ?>
                <span><?= htmlspecialchars($eventVenue) ?></span>
            <?php endif; ?>
        </p>
    </div>

    <div class="ecard-body-inner">
        <div>
            <div class="ecard-section-title">With joy, we invite</div>

            <h2 class="ecard-guest-name">
                <?= htmlspecialchars($user['name']) ?>
            </h2>

            <p class="ecard-text">
                It is with great happiness that we invite you to join us as we celebrate
                this special moment of love and unity.
            </p>

            <p class="ecard-text" style="margin-top:6px;">
                Ticket type:
                <strong><?= htmlspecialchars(ucfirst($user['pricing'])) ?></strong>
                <?php if ($user['pricing'] === 'single'): ?>
                    <span style="font-size:0.78rem;color:#777;">(Admits one guest)</span>
                <?php else: ?>
                    <span style="font-size:0.78rem;color:#777;">(Admits two guests)</span>
                <?php endif; ?>
            </p>

            <div class="ecard-pill" style="margin-top:8px;">
                <span>Ticket status:</span>
                <?php if ($user['paid']): ?>
                    <span class="badge badge-paid">Paid &amp; Confirmed</span>
                <?php else: ?>
                    <span class="badge badge-unpaid">Payment Required</span>
                <?php endif; ?>
            </div>

            <?php if ($eventTheme): ?>
                <p class="ecard-text" style="margin-top:10px;">
                    Theme / Dress code:
                    <strong><?= htmlspecialchars($eventTheme) ?></strong>
                </p>
            <?php endif; ?>

            <p class="ecard-text" style="margin-top:12px;">
                Kindly arrive at least <strong>30 minutes before the start time</strong>
                to allow smooth check-in and seating.
            </p>
        </div>

        <div class="ecard-qr-box">
            <div class="ecard-qr-label">Entrance QR Code</div>
            <img src="<?= htmlspecialchars($qr) ?>" alt="Ticket QR">

            <div class="ecard-ticket-id">
                Ticket ID: <strong><?= htmlspecialchars($ticketId) ?></strong>
            </div>

            <div class="ecard-note">
                Please present this digital card or a clear screenshot at the gate.
                Our team will scan this QR to verify your ticket and grant access.
            </div>
        </div>
    </div>

    <div class="ecard-footer">
        <span>
            This invitation is personal to the named guest(s). For any changes, please
            contact the event organizers in advance.
        </span>
        <span>
            Powered by <strong>TekiSOFT · TUMESSE EVENTS</strong>
        </span>
    </div>

</div>
</body>
</html>