<?php
// Build absolute URL based on current request and correct folder
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host   = $_SERVER['HTTP_HOST'];
$script = $_SERVER['SCRIPT_NAME'];              // e.g. /tumasse/public/guest.php
$folder = trim(dirname($script), '/');          // tumasse/public

// Get base URL of your public folder
$publicUrl = $scheme . "://" . $host . "/" . $folder;

// FULL URL of background image (auto-detects tumasse folder)
$bgUrl = $publicUrl . "/assets/images/mahemba2.png";
?>
<!doctype html>
<html lang="sw">
<head>
    <meta charset="utf-8">
    <title>TUMESSE EVENTS – Mwaliko kwa <?= htmlspecialchars($user['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
</head>

<body style="margin:0;font-family:'Times New Roman', Georgia, serif; background:#f3ece4;">

<div style="min-height:100vh;display:flex;align-items:center;justify-content:center;padding:18px;">
    <div style="
        max-width:350px;
        width:100%;
        border-radius:18px;
        overflow:hidden;
        box-shadow:0 18px 45px rgba(0,0,0,0.25);
        background-image:url('<?= $bgUrl ?>');
        background-size:cover;
        background-position:center;
        background-repeat:no-repeat;
        position:relative;
    ">
        <div style="background:rgba(255,255,255,0.00);padding:80px 34px 80px;">

            <p style="text-align:center;font-size:12px;letter-spacing:1px;text-transform:uppercase;margin:0 0 15px;color:#915c26;">
                <b>Ndugu na Rafiki yangu 
                Tunapokaribia kushuhudia tukio la 
                kipekee la ndoa yangu </b>
            </p>

            <h1 style="text-align:center;font-size:35px;margin:0 0 15px;color:#b07a33;
                       font-family:'Mea Culpa','Edwardian Script ITC','Segoe Script',cursive;">
                Mahemba Mussa Bekha
            </h1>

            <p style="text-align:center;font-size:12px;line-height:1.7;text-transform:uppercase;color:#915c26;margin:0 0 18px;">
                Napenda kukuomba kwa upendo na 
                heshima mchango wako katika harusi yangu 
                itakayofanyika Dar es Salaam,
                Ukumbi wa Mlimani City tarehe 13 Dec, 2025
            </p>

            <p style="text-align:center;font-size:12px;line-height:1.7;text-transform:uppercase;color:#915c26;margin:0 0 18px;">
                Mchango wako ni baraka kubwa kwangu na utanisaidia kufanya siku hii iwe ya furaha na kumbukumbu
            </p>

            <p style="text-align:center;font-size:12px;text-transform:uppercase;color:#915c26;margin:10px 0 4px;">
                Michango itapokelewa kupitia 
                akaunti zifuatazo
            </p>

            <p style="text-align:center;font-size:11px;text-transform:uppercase;color:#915c26;margin:0 0 18px;">
                <b>
                Mahemba Mussa Bekha – 0152301557600 (CRDB)<br>
                Mahemba Mussa Bekha – 0755074421 (M-Pesa) </b>
            </p>

            <br>
            <div style="tex-align:center;border-top:1px solid rgba(150,120,80,0.35);margin-top:5px;padding-top:8px;
                        font-size:11px;color:#7b6a54;display:flex;justify-content:space-between;flex-wrap:wrap;gap:4px;">
                <span>
                    Kadi hii ya mchango imetumwa kwa:
                    <strong><?= htmlspecialchars($user['name']) ?></strong>
                   
                </span>
            </div>

        </div>
    </div>
</div>

</body>
</html>