<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($eventName) ?> – Save the Date for <?= htmlspecialchars($user['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body class="ecard-body ecard-modern">
<div class="ecard-shell">

    <div class="ecard-header">
        <div class="ecard-title">SAVE THE DATE</div>
        <p class="ecard-subtitle">
            <span><?= htmlspecialchars($eventName) ?></span>
            <?php if ($eventDate): ?>
                <span><?= htmlspecialchars($eventDate) ?></span>
            <?php endif; ?>
            <?php if ($eventVenue): ?>
                <span><?= htmlspecialchars($eventVenue) ?></span>
            <?php endif; ?>
        </p>
    </div>

    <div class="ecard-body-inner">
        <div>
            <div class="ecard-section-title">Guest</div>
            <h2 class="ecard-guest-name"><?= htmlspecialchars($user['name']) ?></h2>
            <p class="ecard-text">
                You are officially invited to join us for this special celebration.
            </p>

            <p class="ecard-text">
                Ticket type:
                <strong><?= htmlspecialchars(ucfirst($user['pricing'])) ?></strong>
            </p>

            <div class="ecard-pill">
                <?php if ($user['paid']): ?>
                    <span class="badge badge-paid">Paid ticket</span>
                <?php else: ?>
                    <span class="badge badge-unpaid">Payment pending</span>
                <?php endif; ?>
            </div>

            <?php if ($eventTheme): ?>
                <p class="ecard-text" style="margin-top:10px;">
                    Theme: <strong><?= htmlspecialchars($eventTheme) ?></strong>
                </p>
            <?php endif; ?>

            <p class="ecard-text" style="margin-top:12px;">
                Keep this card safe on your phone; it will be used during check-in.
            </p>
        </div>

        <div class="ecard-qr-box">
            <div class="ecard-qr-label">Digital Ticket</div>
            <img src="<?= htmlspecialchars($qr) ?>" alt="Ticket QR">
            <div class="ecard-ticket-id">
                Ticket ID: <strong><?= htmlspecialchars($ticketId) ?></strong>
            </div>
            <div class="ecard-note">
                The QR contains your secure ticket code for gate verification.
            </div>
        </div>
    </div>

    <div class="ecard-footer">
        <span>Please confirm your availability with the organizers if requested.</span>
        <span>Powered by <strong>TekiSOFT · TUMESSE EVENTS</strong></span>
    </div>

</div>
</body>
</html>