<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($eventName) ?> – Invitation for <?= htmlspecialchars($user['name']) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body class="ecard-body ecard-photo">
<div class="ecard-shell">

    <div class="ecard-header">
        <div class="ecard-title"><?= htmlspecialchars($eventName) ?></div>
        <p class="ecard-subtitle">
            <?php if ($eventDate): ?>
                <span><?= htmlspecialchars($eventDate) ?></span>
            <?php endif; ?>
            <?php if ($eventVenue): ?>
                <span><?= htmlspecialchars($eventVenue) ?></span>
            <?php endif; ?>
        </p>
    </div>

    <div class="ecard-body-inner">
        <div>
            <div class="ecard-section-title">Special Invitation</div>
            <h2 class="ecard-guest-name"><?= htmlspecialchars($user['name']) ?></h2>
            <p class="ecard-text">
                You are warmly invited to celebrate with us.
            </p>

            <p class="ecard-text">
                Ticket type:
                <strong><?= htmlspecialchars(ucfirst($user['pricing'])) ?></strong>
            </p>

            <div class="ecard-pill">
                <span>Status:</span>
                <?php if ($user['paid']): ?>
                    <span class="badge badge-paid">Paid Ticket</span>
                <?php else: ?>
                    <span class="badge badge-unpaid">Payment Pending</span>
                <?php endif; ?>
            </div>

            <?php if ($eventTheme): ?>
                <p class="ecard-text" style="margin-top:10px;">
                    Theme: <strong><?= htmlspecialchars($eventTheme) ?></strong>
                </p>
            <?php endif; ?>

            <p class="ecard-text" style="margin-top:12px;">
                Kindly arrive at least <strong>30 minutes early</strong> for smooth check-in.
            </p>
        </div>

        <div class="ecard-qr-box">
            <div class="ecard-qr-label">Your Ticket QR</div>
            <img src="<?= htmlspecialchars($qr) ?>" alt="Ticket QR">
            <div class="ecard-ticket-id">
                Ticket ID: <strong><?= htmlspecialchars($ticketId) ?></strong>
            </div>
            <div class="ecard-note">
                Save or screenshot this card. Scan will be done at the venue gate.
            </div>
        </div>
    </div>

    <div class="ecard-footer">
        <span>We look forward to celebrating this moment with you.</span>
        <span>Powered by <strong>TekiSOFT · TUMESSE EVENTS</strong></span>
    </div>

</div>
</body>
</html>